/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util;

import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import fr.siroz.cariboustonks.CaribouStonks;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9322;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemUtils {
    private ItemUtils() {
    }

    @NotNull
    public static class_2487 getCustomData(@NotNull class_9322 stack) {
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57463();
    }

    public static Optional<class_1792> getItemById(@NotNull String id) {
        try {
            class_2960 search = class_2960.method_60654((String)id);
            return class_7923.field_41178.method_17966(search);
        }
        catch (Exception ex) {
            CaribouStonks.LOGGER.warn("[ItemUtils] Unable to find {} in Item Registry", (Object)id, (Object)ex);
            return Optional.empty();
        }
    }

    @NotNull
    public static List<class_2561> getLore(@NotNull class_1799 stack) {
        return ((class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340)).comp_2401();
    }

    @Nullable
    public static Matcher getLoreLineIfMatch(@NotNull class_1799 stack, @NotNull Pattern pattern) {
        Matcher matcher = pattern.matcher("");
        for (class_2561 line : ItemUtils.getLore(stack)) {
            if (!matcher.reset(line.getString()).matches()) continue;
            return matcher;
        }
        return null;
    }

    @Nullable
    public static String getLoreLineIf(@NotNull class_1799 stack, @NotNull Predicate<String> predicate) {
        for (class_2561 line : ItemUtils.getLore(stack)) {
            String string = line.getString();
            if (!predicate.test(string)) continue;
            return string;
        }
        return null;
    }

    @NotNull
    public static String getConcatenatedLore(@NotNull class_1799 item) {
        return ItemUtils.concatenateLore(ItemUtils.getLore(item));
    }

    @NotNull
    public static String concatenateLore(@NotNull List<class_2561> lore) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < lore.size(); ++i) {
            stringBuilder.append(lore.get(i).getString());
            if (i == lore.size() - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static class_1799 createSkull(@NotNull String textureB64) {
        class_1799 skull = new class_1799((class_1935)class_1802.field_8575);
        try {
            PropertyMap map = new PropertyMap();
            map.put((Object)"textures", (Object)new Property("textures", textureB64));
            class_9296 profile = new class_9296(Optional.of("skull"), Optional.of(UUID.randomUUID()), map);
            skull.method_57379(class_9334.field_49617, (Object)profile);
        }
        catch (Exception ex) {
            CaribouStonks.LOGGER.error("[ItemUtils] Failed to create skull", (Throwable)ex);
        }
        return skull;
    }

    @NotNull
    public static String getHeadTexture(@NotNull class_1799 stack) {
        if (!stack.method_31574(class_1802.field_8575) || !stack.method_57826(class_9334.field_49617)) {
            return "";
        }
        class_9296 profile = (class_9296)stack.method_58694(class_9334.field_49617);
        if (profile == null) {
            return "";
        }
        return profile.comp_2412().get((Object)"textures").stream().filter(Objects::nonNull).map(Property::value).findFirst().orElse("");
    }

    @NotNull
    public static Optional<String> getHeadTextureOptional(@NotNull class_1799 stack) {
        String texture = ItemUtils.getHeadTexture(stack);
        return texture.isBlank() ? Optional.empty() : Optional.of(texture);
    }
}

