/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class TimeUtils {
    private static final Locale LOCALE = Locale.getDefault();
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d+)d?|([01]?\\d|2[0-3])h?|([0-5]?\\d)m?|([0-5]?\\d)s?");
    public static final DateTimeFormatter TIME_HH_MM = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(LOCALE);
    public static final DateTimeFormatter TIME_HH_MM_SS = DateTimeFormatter.ofPattern("HH:mm:ss", LOCALE);
    public static final DateTimeFormatter DATE_SHORT = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(LOCALE);
    public static final DateTimeFormatter DATE_FULL = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).withLocale(LOCALE);
    public static final DateTimeFormatter DATE_TIME_SHORT = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(LOCALE);
    public static final DateTimeFormatter DATE_TIME_FULL = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.MEDIUM).withLocale(LOCALE);

    private TimeUtils() {
    }

    public static long nowMillis() {
        return System.currentTimeMillis();
    }

    public static Duration diffToNow(Instant other) {
        return Duration.between(Instant.now(), other).abs();
    }

    public static Duration duration(@NotNull TimeUnit unit, long amount) {
        return switch (unit) {
            default -> throw new MatchException(null, null);
            case TimeUnit.NANOSECONDS -> Duration.ofNanos(amount);
            case TimeUnit.MICROSECONDS -> Duration.ofNanos(TimeUnit.MICROSECONDS.toNanos(amount));
            case TimeUnit.MILLISECONDS -> Duration.ofMillis(amount);
            case TimeUnit.SECONDS -> Duration.ofSeconds(amount);
            case TimeUnit.MINUTES -> Duration.ofMinutes(amount);
            case TimeUnit.HOURS -> Duration.ofHours(amount);
            case TimeUnit.DAYS -> Duration.ofDays(amount);
        };
    }

    public static Optional<Instant> parseToInstant(@NotNull String input) {
        Duration duration = Duration.ZERO;
        Matcher matcher = TIME_PATTERN.matcher(input);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                duration = duration.plusDays(Long.parseLong(matcher.group(1)));
            }
            if (matcher.group(2) != null) {
                duration = duration.plusHours(Long.parseLong(matcher.group(2)));
            }
            if (matcher.group(3) != null) {
                duration = duration.plusMinutes(Long.parseLong(matcher.group(3)));
            }
            if (matcher.group(4) == null) continue;
            duration = duration.plusSeconds(Long.parseLong(matcher.group(4)));
        }
        if (duration.isZero() || duration.isNegative()) {
            return Optional.empty();
        }
        return Optional.of(Instant.now().plus(duration));
    }

    @NotNull
    public static String formatInstant(@NotNull Instant instant, @NotNull DateTimeFormatter formatter) {
        return TimeUtils.formatInstant(instant, formatter, LOCALE, ZONE_ID);
    }

    @NotNull
    public static String formatInstant(@NotNull Instant instant, @NotNull DateTimeFormatter formatter, @NotNull Locale locale) {
        return TimeUtils.formatInstant(instant, formatter, locale, ZONE_ID);
    }

    @NotNull
    public static String formatInstant(@NotNull Instant instant, @NotNull DateTimeFormatter formatter, @NotNull Locale locale, @NotNull ZoneId zoneId) {
        ZonedDateTime dateTime = instant.atZone(zoneId);
        return dateTime.format(formatter.localizedBy(locale));
    }

    @NotNull
    public static String getDurationFormatted(@NotNull Instant after) {
        return TimeUtils.getDurationFormatted(Instant.now(), after, false);
    }

    @NotNull
    public static String getDurationFormatted(@NotNull Instant after, boolean all) {
        return TimeUtils.getDurationFormatted(Instant.now(), after, all);
    }

    @NotNull
    public static String getDurationFormatted(@NotNull Instant now, @NotNull Instant after) {
        return TimeUtils.getDurationFormatted(now, after, false);
    }

    @NotNull
    public static String getDurationFormatted(@NotNull Instant now, @NotNull Instant after, boolean all) {
        Duration duration = Duration.between(now, after);
        String durationFormatted = String.format("%sd %sh %sm %ss", duration.toDaysPart(), duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart());
        if (all || duration.toDaysPart() > 0L) {
            return duration.toSecondsPart() > 0 ? durationFormatted : "?";
        }
        if (duration.toHoursPart() > 0) {
            return String.format("%sh %sm %ss", duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart());
        }
        if (duration.toMinutesPart() > 0) {
            return String.format("%sm %ss", duration.toMinutesPart(), duration.toSecondsPart());
        }
        if (duration.toSecondsPart() > 0) {
            return String.format("%ss", duration.toSecondsPart());
        }
        return "?";
    }

    @NotNull
    public static String getSimpleTime(int seconds) {
        if (seconds >= 3600) {
            return "> 1h";
        }
        int sec = seconds % 60;
        int min = seconds / 60 % 60;
        Object strSec = sec < 10 ? "0" + sec : Integer.toString(sec);
        Object strMin = min < 10 ? "0" + min : Integer.toString(min);
        return (String)strMin + ":" + (String)strSec;
    }
}

