/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.cooldown;

import fr.siroz.cariboustonks.util.cooldown.Cooldown;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

final class CooldownImpl
implements Cooldown {
    private long lastTested;
    private final long timeout;

    CooldownImpl(long amount, @NotNull TimeUnit unit) {
        this.timeout = unit.toMillis(amount);
        this.lastTested = 0L;
    }

    @Override
    @NotNull
    public OptionalLong getLastTested() {
        return this.lastTested == 0L ? OptionalLong.empty() : OptionalLong.of(this.lastTested);
    }

    @Override
    public void setLastTested(long time) {
        this.lastTested = time <= 0L ? 0L : time;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    @NotNull
    public CooldownImpl copy() {
        return new CooldownImpl(this.timeout, TimeUnit.MILLISECONDS);
    }
}

