/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.http;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.util.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.class_155;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Http {
    private static final String USER_AGENT = "CaribouStonks/" + CaribouStonks.VERSION.getFriendlyString() + " (" + class_155.method_16673().comp_4025() + ")";
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();

    private Http() {
    }

    @Contract(value="_ -> new")
    @NotNull
    public static HttpResponse request(@NotNull String url) throws RuntimeException {
        try {
            HttpRequest request = HttpRequest.newBuilder().GET().header("Accept", "application/json").header("Accept-Encoding", "gzip, deflate").header("User-Agent", USER_AGENT).version(HttpClient.Version.HTTP_2).uri(URI.create(url)).build();
            java.net.http.HttpResponse<InputStream> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
            InputStream decodedInputStream = Http.getDecodedInputStream(response);
            String body = new String(decodedInputStream.readAllBytes());
            return new HttpResponse(response.statusCode(), body);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static InputStream requestGeneric(@NotNull String url, @NotNull Set<String> expectedContentTypes) throws RuntimeException {
        try {
            HttpRequest request = HttpRequest.newBuilder().GET().header("Accept", "*/*").header("Accept-Encoding", "gzip, deflate").header("User-Agent", USER_AGENT).version(HttpClient.Version.HTTP_2).uri(URI.create(url)).build();
            java.net.http.HttpResponse<InputStream> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
            int statusCode = response.statusCode();
            if (statusCode != 200) {
                throw new IllegalStateException("Bad response received! Code: " + statusCode);
            }
            String contentType = response.headers().firstValue("Content-Type").orElse("");
            if (!expectedContentTypes.contains(contentType)) {
                throw new IllegalStateException("Unexpected content type received! Content Type: " + contentType);
            }
            return Http.getDecodedInputStream(response);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static InputStream getDecodedInputStream(@NotNull java.net.http.HttpResponse<InputStream> response) {
        String encoding = response.headers().firstValue("Content-Encoding").orElse("");
        try {
            return switch (encoding) {
                case "" -> response.body();
                case "gzip" -> new GZIPInputStream(response.body());
                case "deflate" -> new InflaterInputStream(response.body());
                default -> throw new UnsupportedOperationException("The server sent content in an unexpected encoding: " + encoding);
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

