/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.math.bezier;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.ToDoubleBiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class Matrix {
    private final double[][] data;
    private final int width;
    private final int height;

    public Matrix(double[] @NotNull [] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Matrix can't be empty");
        }
        this.width = data[0].length;
        this.height = data.length;
        for (double[] row : data) {
            if (row.length == this.width) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.data = this.deepCopy(data);
    }

    public double[] getRow(int index) {
        return (double[])this.data[index].clone();
    }

    public double get(int row, int col) {
        return this.data[row][col];
    }

    public Matrix copy() {
        return new Matrix(this.deepCopy(this.data));
    }

    public Matrix inverse() {
        if (this.width != this.height) {
            throw new IllegalArgumentException("Matrix must be square");
        }
        double[][] a = this.deepCopy(this.data);
        double[][] b = this.identity((int)this.width).data;
        for (int c = 0; c < this.width; ++c) {
            int rBig = c;
            double maxVal = Math.abs(a[c][c]);
            for (int r = c + 1; r < this.height; ++r) {
                double absVal = Math.abs(a[r][c]);
                if (!(absVal > maxVal)) continue;
                maxVal = absVal;
                rBig = r;
            }
            if (maxVal == 0.0) {
                throw new IllegalArgumentException("Cannot invert matrix");
            }
            if (rBig != c) {
                this.swapRows(a, c, rBig);
                this.swapRows(b, c, rBig);
            }
            this.normalizePivotRow(a, b, c);
            this.eliminateOtherRows(a, b, c);
        }
        return new Matrix(b);
    }

    private void swapRows(double[] @NotNull [] array, int i, int j) {
        double[] temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    private void normalizePivotRow(double[] @NotNull [] a, double[] @NotNull [] b, int c) {
        double pivot = a[c][c];
        int s = c;
        while (s < this.width) {
            double[] dArray = a[c];
            int n = s++;
            dArray[n] = dArray[n] / pivot;
        }
        s = 0;
        while (s < this.width) {
            double[] dArray = b[c];
            int n = s++;
            dArray[n] = dArray[n] / pivot;
        }
    }

    private void eliminateOtherRows(double[][] a, double[][] b, int c) {
        for (int r2 = 0; r2 < this.height; ++r2) {
            int s;
            if (r2 == c) continue;
            double factor = -a[r2][c];
            for (s = c; s < this.width; ++s) {
                double[] dArray = a[r2];
                int n = s;
                dArray[n] = dArray[n] + factor * a[c][s];
            }
            for (s = 0; s < this.width; ++s) {
                double[] dArray = b[r2];
                int n = s;
                dArray[n] = dArray[n] + factor * b[c][s];
            }
        }
    }

    public Matrix transpose() {
        double[][] transposed = this.createArray(this.width, this.height, (row, col) -> this.data[col][row]);
        return new Matrix(transposed);
    }

    public Matrix multiply(@NotNull Matrix other) {
        if (this.width != other.height) {
            throw new IllegalArgumentException("Invalid Matrix sizes");
        }
        double[][] result = this.createArray(this.height, other.width, (row, col) -> {
            double sum = 0.0;
            for (int k = 0; k < this.width; ++k) {
                sum += this.data[row][k] * other.data[k][col];
            }
            return sum;
        });
        return new Matrix(result);
    }

    public Matrix multiply(double scalar) {
        double[][] result = this.createArray(this.height, this.width, (row, col) -> this.data[row][col] * scalar);
        return new Matrix(result);
    }

    public Matrix add(@NotNull Matrix other) {
        if (this.width != other.width || this.height != other.height) {
            throw new IllegalArgumentException("Invalid Dimensions");
        }
        double[][] result = this.createArray(this.height, this.width, (row, col) -> this.data[row][col] + other.data[row][col]);
        return new Matrix(result);
    }

    public Matrix subtract(@NotNull Matrix other) {
        if (this.width != other.width || this.height != other.height) {
            throw new IllegalArgumentException("Invalid Dimensions");
        }
        double[][] result = this.createArray(this.height, this.width, (row, col) -> this.data[row][col] - other.data[row][col]);
        return new Matrix(result);
    }

    public String toString() {
        return Arrays.stream(this.data).map(row -> Arrays.stream(row).mapToObj(cell -> " " + cell).collect(Collectors.joining())).collect(Collectors.joining("\n"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Matrix)) return false;
        Matrix matrix = (Matrix)o;
        if (this.height != matrix.height) return false;
        if (this.width != matrix.width) return false;
        if (!Arrays.deepEquals((Object[])this.data, (Object[])matrix.data)) return false;
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.data);
    }

    private double[] @NotNull [] deepCopy(double[] @NotNull [] array) {
        double[][] copy = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = (double[])array[i].clone();
        }
        return copy;
    }

    @NotNull
    private Matrix identity(int size) {
        double[][] result = this.createArray(size, size, (row, col) -> Objects.equals(row, col) ? 1.0 : 0.0);
        return new Matrix(result);
    }

    private double[] @NotNull [] createArray(int rows, int cols, ToDoubleBiFunction<Integer, Integer> function) {
        double[][] array = new double[rows][cols];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                array[row][col] = function.applyAsDouble(row, col);
            }
        }
        return array;
    }
}

