/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.render;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_11285;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryUtil;

@ApiStatus.Internal
public final class Renderer {
    private static Renderer instance;
    private static final class_310 CLIENT;
    private static final class_9799 GENERAL_ALLOCATOR;
    private static final Vector4f COLOR_MODULATOR;
    private static final float DEFAULT_LINE_WIDTH = 0.0f;
    private final List<RenderPipeline> excludedFromBatching = new ArrayList<RenderPipeline>();
    private final Int2ObjectMap<class_9799> allocators = new Int2ObjectArrayMap(5);
    private final Int2ObjectMap<BatchedDraw> batchedDraws = new Int2ObjectArrayMap(5);
    private final Map<VertexFormat, class_11285> vertexBuffers = new Object2ObjectOpenHashMap();
    private final List<PreparedDraw> preparedDraws = new ArrayList<PreparedDraw>();
    private final List<Draw> draws = new ArrayList<Draw>();
    @Nullable
    private BatchedDraw lastUnbatchedDraw = null;

    private Renderer() {
    }

    public static Renderer getInstance() {
        return instance == null ? (instance = new Renderer()) : instance;
    }

    void excludePipelineFromBatching(RenderPipeline pipeline) {
        this.excludedFromBatching.add(pipeline);
    }

    void executeDraws() {
        this.endBatches();
        this.setupDraws();
        for (Draw draw : this.draws) {
            this.draw(draw);
        }
        for (class_11285 buffer : this.vertexBuffers.values()) {
            buffer.method_71121();
        }
        this.batchedDraws.clear();
        this.preparedDraws.clear();
        this.draws.clear();
    }

    public class_287 getBuffer(@NotNull RenderPipeline pipeline) {
        return this.getBuffer(pipeline, null, 0.0f);
    }

    public class_287 getBuffer(@NotNull RenderPipeline pipeline, @NotNull GpuTextureView textureView) {
        return this.getBuffer(pipeline, textureView, 0.0f);
    }

    public class_287 getBuffer(@NotNull RenderPipeline pipeline, float lineWidth) {
        return this.getBuffer(pipeline, null, lineWidth);
    }

    public void close() {
        GENERAL_ALLOCATOR.close();
        for (class_9799 allocator : this.allocators.values()) {
            allocator.close();
        }
        for (class_11285 vertexBuffer : this.vertexBuffers.values()) {
            vertexBuffer.close();
        }
    }

    private class_287 getBuffer(RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
        if (!this.excludedFromBatching.contains(pipeline)) {
            return this.setupBatched(pipeline, textureView, lineWidth);
        }
        return this.setupUnbatched(pipeline, textureView, lineWidth);
    }

    private class_287 setupBatched(RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
        int hash = this.hash(pipeline, textureView, lineWidth);
        BatchedDraw draw = (BatchedDraw)this.batchedDraws.get(hash);
        if (draw == null) {
            class_9799 allocator = (class_9799)this.allocators.computeIfAbsent(hash, _hash -> new class_9799(786432));
            class_287 bufferBuilder = new class_287(allocator, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
            this.batchedDraws.put(hash, (Object)new BatchedDraw(bufferBuilder, pipeline, textureView, lineWidth));
            return bufferBuilder;
        }
        return draw.bufferBuilder();
    }

    @NotNull
    private class_287 setupUnbatched(RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
        if (this.lastUnbatchedDraw != null) {
            this.prepareBatchedDraw(this.lastUnbatchedDraw);
        }
        class_287 bufferBuilder = new class_287(GENERAL_ALLOCATOR, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
        this.lastUnbatchedDraw = new BatchedDraw(bufferBuilder, pipeline, textureView, lineWidth);
        return bufferBuilder;
    }

    private int hash(@NotNull RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
        int hash = 1;
        hash = 31 * hash + pipeline.hashCode();
        hash = 31 * hash + Objects.hashCode(textureView);
        hash = 31 * hash + Float.hashCode(lineWidth);
        return hash;
    }

    private void endBatches() {
        for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(this.batchedDraws)) {
            this.prepareBatchedDraw((BatchedDraw)entry.getValue());
        }
        if (this.lastUnbatchedDraw != null) {
            this.prepareBatchedDraw(this.lastUnbatchedDraw);
            this.lastUnbatchedDraw = null;
        }
    }

    private void prepareBatchedDraw(@NotNull BatchedDraw draw) {
        this.preparedDraws.add(new PreparedDraw(draw.bufferBuilder().method_60800(), draw.pipeline(), draw.textureView(), draw.lineWidth()));
    }

    private void setupDraws() {
        this.setupVertexBuffers();
        Object2IntOpenHashMap vertexBufferPositions = new Object2IntOpenHashMap();
        for (PreparedDraw prepared : this.preparedDraws) {
            class_9801 builtBuffer = prepared.builtBuffer();
            class_9801.class_4574 drawParameters = builtBuffer.method_60822();
            VertexFormat format = drawParameters.comp_749();
            class_11285 vertices = this.vertexBuffers.get(format);
            ByteBuffer vertexData = builtBuffer.method_60818();
            int vertexBufferPosition = vertexBufferPositions.getInt((Object)format);
            int remainingVertexBytes = vertexData.remaining();
            this.copyDataInto(vertices, vertexData, vertexBufferPosition, remainingVertexBytes);
            vertexBufferPositions.put((Object)format, vertexBufferPosition + remainingVertexBytes);
            this.draws.add(new Draw(builtBuffer, vertices.method_71119(), vertexBufferPosition / format.getVertexSize(), drawParameters.comp_751(), prepared.pipeline(), prepared.textureView(), prepared.lineWidth()));
        }
    }

    private void copyDataInto(@NotNull class_11285 target, ByteBuffer source, int position, int remainingBytes) {
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        try (GpuBuffer.MappedView mappedView = commandEncoder.mapBuffer(target.method_71119().slice(position, remainingBytes), false, true);){
            MemoryUtil.memCopy((ByteBuffer)source, (ByteBuffer)mappedView.data());
        }
    }

    private void setupVertexBuffers() {
        Object2IntMap<VertexFormat> vertexBufferSizes = this.collectVertexBufferSizes();
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(vertexBufferSizes)) {
            VertexFormat format = (VertexFormat)entry.getKey();
            int vertexBufferSize = entry.getIntValue();
            this.vertexBuffers.compute(format, (k, vertexBuffer) -> this.initOrResizeBuffer((class_11285)vertexBuffer, "CaribouStonks vertex buffer for: " + String.valueOf(format), vertexBufferSize));
        }
    }

    @Contract(value="null, _, _ -> new")
    @NotNull
    private class_11285 initOrResizeBuffer(class_11285 buffer, String name, int neededSize) {
        if (buffer == null || buffer.method_71312() < neededSize) {
            if (buffer != null) {
                buffer.close();
            }
            return new class_11285(() -> name, 34, neededSize);
        }
        return buffer;
    }

    @NotNull
    private Object2IntMap<VertexFormat> collectVertexBufferSizes() {
        Object2IntOpenHashMap vertexSizes = new Object2IntOpenHashMap();
        for (PreparedDraw prepared : this.preparedDraws) {
            class_9801.class_4574 drawParameters = prepared.builtBuffer().method_60822();
            VertexFormat format = drawParameters.comp_749();
            vertexSizes.put((Object)format, vertexSizes.getOrDefault((Object)format, 0) + drawParameters.comp_750() * format.getVertexSize());
        }
        return vertexSizes;
    }

    private void draw(@NotNull Draw draw) {
        VertexFormat.class_5595 indexType;
        GpuBuffer indices;
        if (draw.pipeline().getVertexFormatMode() == VertexFormat.class_5596.field_27382) {
            draw.builtBuffer().method_60819(GENERAL_ALLOCATOR, RenderSystem.getProjectionType().method_65045());
            indices = draw.pipeline().getVertexFormat().uploadImmediateIndexBuffer(draw.builtBuffer().method_60821());
            indexType = draw.builtBuffer().method_60822().comp_753();
        } else {
            RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)draw.pipeline().getVertexFormatMode());
            indices = shapeIndexBuffer.method_68274(draw.indexCount());
            indexType = shapeIndexBuffer.method_31924();
        }
        this.draw(draw, indices, indexType);
    }

    private void draw(@NotNull Draw draw, GpuBuffer indices, VertexFormat.class_5595 indexType) {
        this.applyViewOffsetZLayering();
        GpuBufferSlice dynamicTransforms = this.setupDynamicTransforms(draw.lineWidth);
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "cariboustonks world rendering", this.getMainColorTexture(), OptionalInt.empty(), this.getMainDepthTexture(), OptionalDouble.empty());){
            renderPass.setPipeline(draw.pipeline);
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.setUniform("DynamicTransforms", dynamicTransforms);
            if (draw.textureView != null) {
                renderPass.bindSampler("Sampler0", draw.textureView);
            }
            renderPass.setVertexBuffer(0, draw.vertices);
            renderPass.setIndexBuffer(indices, indexType);
            renderPass.drawIndexed(draw.baseVertex, 0, draw.indexCount, 1);
        }
        draw.builtBuffer().close();
        this.unapplyViewOffsetZLayering();
    }

    private GpuBufferSlice setupDynamicTransforms(float lineWidth) {
        return RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)COLOR_MODULATOR, (Vector3fc)RenderSystem.getModelOffset(), (Matrix4fc)RenderSystem.getTextureMatrix(), lineWidth);
    }

    private GpuTextureView getMainColorTexture() {
        return CLIENT.method_1522().method_71639();
    }

    private GpuTextureView getMainDepthTexture() {
        return CLIENT.method_1522().method_71640();
    }

    private void applyViewOffsetZLayering() {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        RenderSystem.getProjectionType().method_65046((Matrix4f)modelViewStack, 1.0f);
    }

    private void unapplyViewOffsetZLayering() {
        RenderSystem.getModelViewStack().popMatrix();
    }

    static {
        CLIENT = class_310.method_1551();
        GENERAL_ALLOCATOR = new class_9799(1536);
        COLOR_MODULATOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private record BatchedDraw(class_287 bufferBuilder, RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
    }

    private record Draw(class_9801 builtBuffer, GpuBuffer vertices, int baseVertex, int indexCount, RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
    }

    private record PreparedDraw(class_9801 builtBuffer, RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
    }
}

