/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.render.animation;

import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.math.MathUtils;
import java.awt.Color;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class AnimationUtils {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final int RAINBOW_CHANGE_RATE = 10;
    private static fr.siroz.cariboustonks.util.colors.Color currentRainbowColor = Colors.RED;

    private AnimationUtils() {
    }

    @ApiStatus.Internal
    public static void initAnimationUtilities() {
        ClientTickEvents.END_CLIENT_TICK.register(AnimationUtils::onTick);
    }

    @NotNull
    public static class_2561 applyRainbow(@NotNull String text) {
        class_5250 result = class_2561.method_43473();
        long time = class_156.method_659();
        float speed = 2000.0f;
        float spacing = 0.05f;
        float saturation = 0.8f;
        float brightness = 0.95f;
        for (int i = 0; i < text.length(); ++i) {
            float hue = ((float)(time % (long)((int)speed)) / speed - (float)i * spacing) % 1.0f;
            hue = (hue + 1.0f) % 1.0f;
            int rgb = Color.HSBtoRGB(hue, saturation, brightness);
            result.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(i))).method_54663(rgb));
        }
        return result;
    }

    public static fr.siroz.cariboustonks.util.colors.Color getCurrentRainbowColor() {
        return currentRainbowColor;
    }

    public static void showSpecialEffect(@NotNull class_1799 item, @Nullable class_2394 particle, @Range(from=1L, to=120L) int particleAge, @NotNull class_3414 sound, float soundVolume, float soundPitch) {
        AnimationUtils.showSpecialEffect(null, item, particle, particleAge, sound, soundVolume, soundPitch);
    }

    public static void showSpecialEffect(@Nullable class_2561 title, @NotNull class_1799 item, @Nullable class_2394 particle, @Range(from=1L, to=120L) int particleAge, @NotNull class_3414 sound, float soundVolume, float soundPitch) {
        if (AnimationUtils.CLIENT.field_1724 != null && AnimationUtils.CLIENT.field_1687 != null) {
            if (title != null) {
                Client.showTitle(title, 0, 60, 20);
            }
            AnimationUtils.CLIENT.field_1773.method_3189(item);
            if (particle != null) {
                AnimationUtils.CLIENT.field_1713.method_3051((class_1297)AnimationUtils.CLIENT.field_1724, particle, particleAge);
            }
            AnimationUtils.CLIENT.field_1724.method_5783(sound, soundVolume, soundPitch);
        }
    }

    private static void onTick(class_310 _client) {
        int r = AnimationUtils.currentRainbowColor.r;
        int g = AnimationUtils.currentRainbowColor.g;
        int b = AnimationUtils.currentRainbowColor.b;
        if (r > 0 && b == 0) {
            r -= 10;
            g += 10;
        }
        if (g > 0 && r == 0) {
            g -= 10;
            b += 10;
        }
        if (b > 0 && g == 0) {
            r += 10;
            b -= 10;
        }
        r = MathUtils.clamp(r, 0, 255);
        g = MathUtils.clamp(g, 0, 255);
        b = MathUtils.clamp(b, 0, 255);
        currentRainbowColor = new fr.siroz.cariboustonks.util.colors.Color(r, g, b, 255);
    }
}

