/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.changelog;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.changelog.ChangelogEntry;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.event.SkyBlockEvents;
import fr.siroz.cariboustonks.screen.changelog.ChangelogScreen;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.http.Http;
import fr.siroz.cariboustonks.util.http.HttpResponse;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import org.apache.http.client.HttpResponseException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ChangelogManager {
    private static final String GITHUB_REPO_URL = "https://api.github.com/repos/Siroz555/CaribouStonks/releases";
    private static final String CURRENT_VERSION = CaribouStonks.VERSION.getFriendlyString().replaceAll("\\+.*$", "");
    private static final Comparator<Version> COMPARATOR = Comparable::compareTo;
    private static final Path LAST_SEEN_VERSION_PATH = CaribouStonks.CONFIG_DIR.resolve("last_seen_version.txt");
    private final List<ChangelogEntry> changelogEntries = new ArrayList<ChangelogEntry>();
    @Nullable
    private String lastSeenVersion = null;
    private boolean notified = false;

    public ChangelogManager() {
        ClientLifecycleEvents.CLIENT_STARTED.register(this::onClientStarted);
        SkyBlockEvents.JOIN.register(_s -> this.onJoinSkyBlock());
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, _ra) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"stonksviewchangelog").executes(StonksUtils.openScreen(() -> ChangelogScreen.create(this.changelogEntries, this::markChangelogAsSeen)))));
    }

    private void onClientStarted(class_310 client) {
        boolean specialCase;
        this.lastSeenVersion = this.loadLastSeenVersion();
        boolean bl = specialCase = this.lastSeenVersion == null && "0.6.1".equals(CURRENT_VERSION);
        if (specialCase) {
            this.lastSeenVersion = "0.6.0";
        }
        if (specialCase || this.lastSeenVersion != null && !this.lastSeenVersion.equals(CURRENT_VERSION)) {
            CaribouStonks.LOGGER.info("[ChangelogManager] Last seen version is not the current version, fetching changelogs..");
            this.fetchChangelogSinceLastSeen(this.lastSeenVersion);
        } else if (this.lastSeenVersion == null) {
            CaribouStonks.LOGGER.info("[ChangelogManager] No changelog found, first time? Marking as seen..");
            this.markChangelogAsSeen();
        }
    }

    private void onJoinSkyBlock() {
        if (this.notified || this.lastSeenVersion == null || this.changelogEntries.isEmpty()) {
            return;
        }
        this.notified = true;
        TickScheduler.getInstance().runLater(() -> {
            Client.sendMessage((class_2561)class_2561.method_43473());
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Updated!").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)(" " + this.lastSeenVersion + " ")).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"->").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(" " + CURRENT_VERSION + " ")).method_27692(class_124.field_1060)));
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" HERE ").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"to see the changelogs in-game!").method_27692(class_124.field_1054)).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to see the changelogs!").method_27692(class_124.field_1054))).method_10958((class_2558)new class_2558.class_10609("/stonksviewchangelog"))));
            Client.sendMessage((class_2561)class_2561.method_43473());
        }, 3, TimeUnit.SECONDS);
    }

    private void markChangelogAsSeen() {
        this.lastSeenVersion = CURRENT_VERSION;
        this.changelogEntries.clear();
        this.saveLastSeenVersion();
    }

    private void saveLastSeenVersion() {
        if (this.lastSeenVersion != null) {
            try (BufferedWriter writer = Files.newBufferedWriter(LAST_SEEN_VERSION_PATH, new OpenOption[0]);){
                writer.write(this.lastSeenVersion);
            }
            catch (Exception ex) {
                CaribouStonks.LOGGER.error("[ChangelogManager] Unable to save last seen version to file: {}", (Object)LAST_SEEN_VERSION_PATH, (Object)ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String loadLastSeenVersion() {
        if (!Files.exists(LAST_SEEN_VERSION_PATH, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(LAST_SEEN_VERSION_PATH);){
            String line = reader.readLine();
            if (line == null) return null;
            if (line.isBlank()) return null;
            String string = this.parse(line.trim());
            return string;
        }
        catch (Exception ex) {
            CaribouStonks.LOGGER.error("[ChangelogManager] Unable to load last seen version from file: {}", (Object)LAST_SEEN_VERSION_PATH, (Object)ex);
        }
        return null;
    }

    @Nullable
    private String parse(String version) {
        try {
            SemanticVersion.parse((String)version);
            return version;
        }
        catch (VersionParsingException ex) {
            CaribouStonks.LOGGER.warn("[ChangelogManager] Unable to parse version from file: {}", (Object)version, (Object)ex);
            return null;
        }
    }

    private void fetchChangelogSinceLastSeen(@NotNull String lastSeenVersionToParse) {
        CompletableFuture.runAsync(() -> {
            try (HttpResponse response = Http.request(GITHUB_REPO_URL);){
                if (!response.success()) {
                    throw new HttpResponseException(response.statusCode(), response.content());
                }
                String responseBody = response.content();
                if (responseBody == null || responseBody.isEmpty()) {
                    throw new IllegalStateException("GitHub API returned an empty response body");
                }
                JsonArray releases = (JsonArray)GsonProvider.prettyPrinting().fromJson(responseBody, JsonArray.class);
                if (releases == null || releases.isEmpty()) {
                    return;
                }
                this.parseChangelogs(releases, lastSeenVersionToParse);
            }
            catch (Exception ex) {
                CaribouStonks.LOGGER.error("[ChangelogManager] Unable to fetch changelogs from GitHub", (Throwable)ex);
            }
        });
    }

    private void parseChangelogs(@NotNull JsonArray releases, String lastSeenVersionToParse) {
        TreeMap<String, ChangelogEntry> changelogCache = new TreeMap<String, ChangelogEntry>();
        try {
            for (JsonElement element : releases) {
                JsonObject release = element.getAsJsonObject();
                String tagName = release.get("tag_name").getAsString();
                String body = release.has("body") ? release.get("body").getAsString() : "";
                String publishedAt = release.get("published_at").getAsString();
                ChangelogEntry entry = this.parseChangelogBody(tagName, body, publishedAt);
                changelogCache.put(tagName.replace("v", ""), entry);
            }
        }
        catch (Exception ex) {
            CaribouStonks.LOGGER.error("[ChangelogManager] Unable to parse changelogs from GitHub", (Throwable)ex);
        }
        ArrayList<ChangelogEntry> relevantChangelogs = new ArrayList<ChangelogEntry>();
        for (Map.Entry entry : changelogCache.entrySet()) {
            String gitHubVersion = (String)entry.getKey();
            try {
                SemanticVersion currentVersionSem = SemanticVersion.parse((String)CURRENT_VERSION);
                SemanticVersion lastSeenVersionSem = SemanticVersion.parse((String)lastSeenVersionToParse);
                SemanticVersion changelogVersionSem = SemanticVersion.parse((String)gitHubVersion);
                if (COMPARATOR.compare((Version)changelogVersionSem, (Version)lastSeenVersionSem) <= 0 || COMPARATOR.compare((Version)changelogVersionSem, (Version)currentVersionSem) > 0) continue;
                relevantChangelogs.add((ChangelogEntry)entry.getValue());
            }
            catch (VersionParsingException ex) {
                CaribouStonks.LOGGER.warn("[ChangelogManager] Unable to parse versions from GitHub version {}", (Object)gitHubVersion, (Object)ex);
            }
        }
        this.changelogEntries.addAll(relevantChangelogs);
        this.changelogEntries.sort((o1, o2) -> o2.version.compareTo(o1.version));
        if (!this.changelogEntries.isEmpty()) {
            CaribouStonks.LOGGER.info("[ChangelogManager] Found {} relevant changelogs", (Object)this.changelogEntries.size());
        }
        changelogCache.clear();
        relevantChangelogs.clear();
    }

    @NotNull
    private ChangelogEntry parseChangelogBody(@NotNull String version, String body, @NotNull String date) {
        ChangelogEntry entry = new ChangelogEntry();
        entry.version = version.replace("v", "");
        entry.date = date.substring(0, 10);
        if (body == null || body.isEmpty()) {
            return entry;
        }
        String[] lines = body.split("\n");
        List<String> currentSection = null;
        for (String line : lines) {
            String item;
            if ((line = line.trim()).toLowerCase(Locale.ENGLISH).startsWith("## features")) {
                currentSection = entry.feature;
                continue;
            }
            if (line.toLowerCase(Locale.ENGLISH).startsWith("## improvements")) {
                currentSection = entry.improvement;
                continue;
            }
            if (line.toLowerCase(Locale.ENGLISH).startsWith("## fixes")) {
                currentSection = entry.fixed;
                continue;
            }
            if (line.toLowerCase(Locale.ENGLISH).startsWith("## backend")) {
                currentSection = entry.backend;
                continue;
            }
            if (!line.startsWith("-") && !line.startsWith("*") || currentSection == null || (item = line.substring(1).trim()).isEmpty()) continue;
            currentSection.add(item);
        }
        if (entry.isEmpty()) {
            entry.improvement.add(body);
        }
        return entry;
    }
}

