/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.generic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.data.generic.GraphCacheEntry;
import fr.siroz.cariboustonks.core.data.generic.ItemPrice;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.util.ItemLookupKey;
import fr.siroz.cariboustonks.util.http.Http;
import fr.siroz.cariboustonks.util.http.HttpResponse;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import org.apache.http.client.HttpResponseException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class GenericDataSource {
    private static final String NEU_PRICE_HISTORY_URL = "http://pricehistory.notenoughupdates.org/";
    private final Map<String, GraphCacheEntry> graphCache = new HashMap<String, GraphCacheEntry>();
    public static final Duration CACHE_EXPIRATION_PRICE_HISTORY = Duration.ofMinutes(30L);
    private static final String NEU_LOWEST_BIN_AUCTION_URL = "https://moulberry.codes/lowestbin.json";
    private final Object2DoubleMap<String> lowestBinsNEU = new Object2DoubleOpenHashMap();
    private boolean lowestBinsInUpdate = false;
    private boolean lowestBinsError = false;

    @ApiStatus.Internal
    public GenericDataSource() {
        ClientLifecycleEvents.CLIENT_STARTED.register(_mc -> TickScheduler.getInstance().runRepeating(() -> {
            if (ConfigManager.getConfig().general.stonks.auctionTooltipPrice) {
                this.updateLowestBins().thenRun(() -> {
                    this.lowestBinsInUpdate = false;
                    this.lowestBinsError = false;
                    this.checkLowestBinsResult();
                });
            }
        }, 5, TimeUnit.MINUTES));
    }

    public boolean isLowestBinsInUpdate() {
        return this.lowestBinsInUpdate;
    }

    public boolean hasLowestBin(@NotNull ItemLookupKey key) {
        if (key.isNull() || key.getNeuId() == null || this.lowestBinsNEU.isEmpty()) {
            return false;
        }
        return this.lowestBinsNEU.containsKey((Object)key.getNeuId());
    }

    public Optional<Double> getLowestBin(@NotNull ItemLookupKey key) {
        if (key.isNull() || key.getNeuId() == null || this.lowestBinsNEU.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.lowestBinsNEU.getDouble((Object)key.getNeuId()));
    }

    public CompletableFuture<List<ItemPrice>> loadGraphData(@NotNull ItemLookupKey key) {
        if (key.isNull()) {
            return CompletableFuture.completedFuture(null);
        }
        GraphCacheEntry cacheEntry = this.graphCache.get(key.getNeuId());
        if (cacheEntry != null && cacheEntry.isValid()) {
            return CompletableFuture.completedFuture(cacheEntry.data());
        }
        if (cacheEntry != null && !cacheEntry.isValid()) {
            this.graphCache.remove(key.getNeuId());
        }
        return this.fetchGraphData(key);
    }

    @Contract(value="_ -> new")
    @NotNull
    private CompletableFuture<List<ItemPrice>> fetchGraphData(@NotNull ItemLookupKey key) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse response = Http.request("http://pricehistory.notenoughupdates.org/?item=" + key.getNeuId());
            try {
                if (!response.success()) {
                    throw new HttpResponseException(response.statusCode(), response.content());
                }
                JsonObject json = (JsonObject)GsonProvider.prettyPrinting().fromJson(response.content(), JsonObject.class);
                if (json == null) {
                    throw new IllegalStateException("Json is null or empty");
                }
                ArrayList<ItemPrice> result = new ArrayList<ItemPrice>();
                for (Map.Entry element : json.entrySet()) {
                    try {
                        Instant instant = Instant.parse((CharSequence)element.getKey());
                        JsonObject jsonPrice = ((JsonElement)element.getValue()).getAsJsonObject();
                        double buyPrice = jsonPrice.get("b").getAsDouble();
                        Double sellPrice = jsonPrice.has("s") ? Double.valueOf(jsonPrice.get("s").getAsDouble()) : null;
                        result.add(new ItemPrice(instant, buyPrice, sellPrice));
                    }
                    catch (Exception ex) {
                        CaribouStonks.LOGGER.error("[GenericDataSource] Failed to parse price history for {}", (Object)key.getNeuId(), (Object)ex);
                    }
                }
                if (result.size() > 2) {
                    GraphCacheEntry entry = new GraphCacheEntry(result, Instant.now());
                    this.graphCache.put(key.getNeuId(), entry);
                }
                ArrayList<ItemPrice> arrayList = result;
                if (response != null) {
                    response.close();
                }
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    CaribouStonks.LOGGER.error("[GenericDataSource] Failed to fetch price history for {}", (Object)key.getNeuId(), (Object)ex);
                    return null;
                }
            }
        });
    }

    @NotNull
    private CompletableFuture<Void> updateLowestBins() {
        this.lowestBinsInUpdate = true;
        return this.fetchLowestBins().thenAccept(result -> {
            if (result == null || result.isEmpty() || result.size() < 2) {
                this.lowestBinsError = true;
                return;
            }
            this.lowestBinsNEU.clear();
            this.lowestBinsNEU.putAll(result);
        });
    }

    @Contract(value=" -> new")
    @NotNull
    private CompletableFuture<Map<String, Double>> fetchLowestBins() {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse response = Http.request(NEU_LOWEST_BIN_AUCTION_URL);
            try {
                if (!response.success()) {
                    throw new HttpResponseException(response.statusCode(), response.content());
                }
                JsonObject json = (JsonObject)GsonProvider.prettyPrinting().fromJson(response.content(), JsonObject.class);
                if (json == null) {
                    throw new IllegalStateException("Json is null or empty");
                }
                HashMap<String, Double> result = new HashMap<String, Double>();
                for (Map.Entry element : json.entrySet()) {
                    try {
                        result.put((String)element.getKey(), ((JsonElement)element.getValue()).getAsDouble());
                    }
                    catch (Exception ex) {
                        CaribouStonks.LOGGER.error("[GenericDataSource] Failed to parse lowest bin {}", element.getKey(), (Object)ex);
                    }
                }
                HashMap<String, Double> hashMap = result;
                if (response != null) {
                    response.close();
                }
                return hashMap;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    CaribouStonks.LOGGER.error("[GenericDataSource] Failed to fetch Auction lowest bins", (Throwable)ex);
                    return null;
                }
            }
        });
    }

    private void checkLowestBinsResult() {
        if (!this.lowestBinsError) {
            CaribouStonks.LOGGER.info("[GenericDataSource] Updated {} lowest bins", (Object)this.lowestBinsNEU.size());
        } else {
            CaribouStonks.LOGGER.warn("[GenericDataSource] Unable to update lowest bins");
        }
    }
}

