/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.hypixel;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelAPIFixer;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataException;
import fr.siroz.cariboustonks.core.data.hypixel.bazaar.Product;
import fr.siroz.cariboustonks.core.data.hypixel.election.ElectionResult;
import fr.siroz.cariboustonks.core.data.hypixel.fetcher.BazaarFetcher;
import fr.siroz.cariboustonks.core.data.hypixel.fetcher.ElectionFetcher;
import fr.siroz.cariboustonks.core.data.hypixel.fetcher.ItemsFetcher;
import fr.siroz.cariboustonks.core.data.hypixel.item.SkyBlockItem;
import fr.siroz.cariboustonks.core.data.mod.ModDataSource;
import fr.siroz.cariboustonks.util.ItemUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class HypixelDataSource {
    private final HypixelAPIFixer apiFixer = new HypixelAPIFixer();
    private final ModDataSource modDataSource;
    private final ItemsFetcher itemsFetcher;
    private final BazaarFetcher bazaarFetcher;
    private final ElectionFetcher electionFetcher;
    private boolean hasCalledFixMissing = false;

    @ApiStatus.Internal
    public HypixelDataSource(@NotNull ModDataSource modDataSource) {
        this.modDataSource = modDataSource;
        this.itemsFetcher = new ItemsFetcher(this, modDataSource, this.apiFixer);
        this.bazaarFetcher = new BazaarFetcher(this, 5, () -> ConfigManager.getConfig().general.stonks.bazaarTooltipPrice);
        this.electionFetcher = new ElectionFetcher();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> this.onClientStarted());
    }

    private void onClientStarted() {
        this.itemsFetcher.start();
        this.bazaarFetcher.start();
        this.electionFetcher.start();
    }

    @Nullable
    public ElectionResult getElection() {
        return this.electionFetcher.getCachedElection();
    }

    public boolean isBazaarInUpdate() {
        return this.bazaarFetcher.isFetching();
    }

    public boolean hasBazaarItem(@Nullable String skyBlockItemId) {
        if (skyBlockItemId == null || skyBlockItemId.isBlank()) {
            return false;
        }
        return this.bazaarFetcher.getBazaarSnapshot().containsKey(skyBlockItemId);
    }

    public Optional<Product> getBazaarItem(@Nullable String skyBlockItemId) {
        if (skyBlockItemId == null || skyBlockItemId.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.bazaarFetcher.getBazaarSnapshot().get(skyBlockItemId));
    }

    @NotNull
    public class_1799 getItemStack(@NotNull String skyBlockItemId) {
        class_1799 fallback = new class_1799((class_1935)class_1802.field_8077, 1);
        fallback.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)skyBlockItemId));
        if (this.modDataSource.isItemsMappingError()) {
            return fallback;
        }
        try {
            SkyBlockItem skyBlockItem = this.itemsFetcher.getSkyBlockItemsSnapshot().get(skyBlockItemId);
            if (skyBlockItem == null) {
                return fallback;
            }
            String hypixelMaterial = skyBlockItem.material();
            String minecraftId = this.modDataSource.getMinecraftId(hypixelMaterial);
            if (minecraftId == null || minecraftId.equals("NO_MATCH")) {
                return fallback;
            }
            class_1799 itemStack = new class_1799((class_1935)class_1802.field_8077, 1);
            Optional<class_1792> item = ItemUtils.getItemById(minecraftId);
            if (item.isPresent()) {
                itemStack = new class_1799((class_1935)item.get(), 1);
            }
            if (skyBlockItem.skullTexture() != null) {
                itemStack = ItemUtils.createSkull(skyBlockItem.skullTexture());
            }
            itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)skyBlockItemId));
            return itemStack;
        }
        catch (Throwable ex) {
            CaribouStonks.LOGGER.warn("[HypixelDataSource] Unable to create ItemStack for {}", (Object)skyBlockItemId, (Object)ex);
            return fallback;
        }
    }

    @Nullable
    public SkyBlockItem getSkyBlockItem(@Nullable String skyBlockItemId) {
        if (skyBlockItemId == null || skyBlockItemId.isEmpty()) {
            return null;
        }
        return this.itemsFetcher.getSkyBlockItemsSnapshot().get(skyBlockItemId);
    }

    public Optional<SkyBlockItem> getSkyBlockItemOptional(@Nullable String skyBlockItemId) {
        SkyBlockItem item = this.getSkyBlockItem(skyBlockItemId);
        return item == null ? Optional.empty() : Optional.of(item);
    }

    @NotNull
    public @Unmodifiable List<SkyBlockItem> getSkyBlockItems() throws HypixelDataException {
        if (this.modDataSource.isItemsMappingError()) {
            throw new HypixelDataException(class_2561.method_30163((String)"Unable to map SkyBlock Items into Minecraft."));
        }
        if (!this.itemsFetcher.isLastFetchSuccessful()) {
            throw new HypixelDataException(class_2561.method_30163((String)"Unable to fetch SkyBlock Items from Hypixel API."));
        }
        if (this.itemsFetcher.getSkyBlockItemsSnapshot().isEmpty()) {
            throw new HypixelDataException(class_2561.method_30163((String)"No SkyBlock Items is registered."));
        }
        return new ArrayList<SkyBlockItem>(this.itemsFetcher.getSkyBlockItemsSnapshot().values());
    }

    @Contract(value=" -> new")
    @NotNull
    public Set<String> getSkyBlockItemsIds() {
        return new HashSet<String>(this.itemsFetcher.getSkyBlockItemsSnapshot().keySet());
    }

    public int getSkyBlockItemCounts() {
        return this.itemsFetcher.getSkyBlockItemsSnapshot().size();
    }

    @ApiStatus.Internal
    public void fixSkyBlockItems() {
        if (this.itemsFetcher.isLastFetchSuccessful() && this.bazaarFetcher.isFirstBazaarUpdated() && !this.hasCalledFixMissing) {
            this.hasCalledFixMissing = true;
            CaribouStonks.LOGGER.info("[HypixelDataSource] Fixing Hypixel SkyBlock Items..");
            int fixedEnchants = 0;
            int fixedEssences = 0;
            int fixedShards = 0;
            for (String bazaarProductId : this.bazaarFetcher.getBazaarSnapshot().keySet()) {
                if (this.itemsFetcher.getSkyBlockItemsSnapshot().containsKey(bazaarProductId)) continue;
                try {
                    if (this.apiFixer.isEnchantment(bazaarProductId)) {
                        this.itemsFetcher.putItem(bazaarProductId, this.apiFixer.createEnchant(bazaarProductId));
                        ++fixedEnchants;
                        continue;
                    }
                    if (this.apiFixer.isEssence(bazaarProductId)) {
                        this.itemsFetcher.putItem(bazaarProductId, this.apiFixer.createEssence(bazaarProductId));
                        ++fixedEssences;
                        continue;
                    }
                    if (this.apiFixer.isShard(bazaarProductId)) {
                        SkyBlockItem shard = this.apiFixer.createShard(bazaarProductId);
                        if (shard != null) {
                            this.itemsFetcher.putItem(bazaarProductId, shard);
                            ++fixedShards;
                            continue;
                        }
                        CaribouStonks.LOGGER.warn("[HypixelDataSource] Unable to create {} Shard! Not registered in ModDataSource.", (Object)bazaarProductId);
                        continue;
                    }
                    CaribouStonks.LOGGER.warn("[HypixelDataSource] Unable to fix {}. Not identified!", (Object)bazaarProductId);
                }
                catch (Throwable ex) {
                    CaribouStonks.LOGGER.error("[HypixelDataSource] Fix for {} failed", (Object)bazaarProductId, (Object)ex);
                }
            }
            CaribouStonks.LOGGER.info("[HypixelDataSource] Fixed {} enchants, {} essences and {} Shards from Bazaar to SkyBlock Items", new Object[]{fixedEnchants, fixedEssences, fixedShards});
        }
    }
}

