/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.hypixel.election;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Perk {
    SLAYER_XP_BUFF("Slayer XP Buff"),
    PATHFINDER("Pathfinder"),
    SLASHED_PRICING("SLASHED Pricing"),
    MINING_FIESTA("Mining Festa"),
    MINING_XP_BUFF("Mining XP Buff"),
    MOLTEN_FORGE("Molten Forge"),
    PROSPECTION("Prospection"),
    PET_XP_BUFF("Pet XP Buff"),
    LUCKY("Lucky!"),
    MYTHOLOGICAL_RITUAL("Mythological Ritual"),
    SHARING_IS_CARING("Sharing is Caring"),
    LONG_TERM_INVESTMENT("Long Term Investment"),
    SHOPPING_SPREE("Shopping Spree"),
    STOCK_EXCHANGE("Stock Exchange"),
    VOLUME_TRADING("Volume Trading"),
    BLOOMING_BUSINESS("Blooming Business"),
    GOATED("GOATed"),
    PELT_POCALYPSE("Pelt Pocalypse"),
    PEST_ERADICATOR("Pest Eradiator"),
    A_TIME_FOR_GIVING("A Time for Giving"),
    CHIVALROUS_CARNIVAL("Chivalrous Carnival"),
    EXTRA_EVENT("Extra Event"),
    SWEET_BENEVOLENCE("Sweet Benevolence"),
    DOUBLE_TROUBLE("Double Trouble"),
    FISHING_XP_BUFF("Fishing XP Buff"),
    FISHING_FESTIVAL("Fishing Festival"),
    LUCK_OF_THE_SEA_2_0("Luck of the Sea 2.0"),
    BENEDICTION("Benediction"),
    MARAUDER("Marauder"),
    EZPZ("EZPZ"),
    UNKNOWN("");

    private static final Map<String, Perk> BY_DISPLAY_NAME;
    private final String displayName;

    private Perk(String displayName) {
        this.displayName = displayName;
    }

    @NotNull
    public static Perk fromDisplayName(@Nullable String displayName) {
        if (displayName == null) {
            return UNKNOWN;
        }
        return BY_DISPLAY_NAME.getOrDefault(displayName, UNKNOWN);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    static {
        BY_DISPLAY_NAME = Arrays.stream(Perk.values()).collect(Collectors.toUnmodifiableMap(Perk::getDisplayName, Function.identity()));
    }
}

