/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.hypixel.fetcher;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataSource;
import fr.siroz.cariboustonks.core.data.hypixel.bazaar.Product;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.core.scheduler.AsyncScheduler;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.util.http.Http;
import fr.siroz.cariboustonks.util.http.HttpResponse;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import org.apache.http.client.HttpResponseException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class BazaarFetcher {
    private static final String BAZAAR_URL = "https://api.hypixel.net/v2/skyblock/bazaar";
    private final HypixelDataSource hypixelDataSource;
    private final int intervalInMinutes;
    private final BooleanSupplier shouldFetch;
    private final AtomicBoolean fetchInProgress;
    private final AtomicBoolean lastFetchSuccessful;
    private final AtomicReference<Map<String, Product>> bazaarCache;
    private volatile Instant lastBazaarUpdate;
    private volatile boolean firstBazaarUpdated;

    public BazaarFetcher(HypixelDataSource hypixelDataSource, int intervalInMinutes, @NotNull BooleanSupplier shouldFetch) {
        this.hypixelDataSource = hypixelDataSource;
        this.intervalInMinutes = intervalInMinutes;
        this.shouldFetch = shouldFetch;
        this.fetchInProgress = new AtomicBoolean(false);
        this.lastFetchSuccessful = new AtomicBoolean(false);
        this.bazaarCache = new AtomicReference(Map.of());
        this.lastBazaarUpdate = null;
        this.firstBazaarUpdated = false;
        CaribouStonks.LOGGER.info("[BazaarFetcher] Bazaar products will be updated every {} minute", (Object)intervalInMinutes);
    }

    public void start() {
        TickScheduler.getInstance().runRepeating(() -> {
            if (this.shouldFetch.getAsBoolean()) {
                this.triggerFetch().thenRun(() -> {
                    if (this.lastFetchSuccessful.get()) {
                        CaribouStonks.LOGGER.info("[BazaarFetcher] {} products updated. (last update: {})", (Object)this.bazaarCache.get().size(), (Object)(this.lastBazaarUpdate == null ? "n/a" : this.lastBazaarUpdate.toString()));
                    }
                    if (!this.firstBazaarUpdated) {
                        this.firstBazaarUpdated = true;
                        this.hypixelDataSource.fixSkyBlockItems();
                    }
                });
            }
        }, this.intervalInMinutes, TimeUnit.MINUTES);
    }

    public Map<String, Product> getBazaarSnapshot() {
        return this.bazaarCache.get();
    }

    public boolean isFirstBazaarUpdated() {
        return this.firstBazaarUpdated;
    }

    public boolean isFetching() {
        return this.fetchInProgress.get();
    }

    @NotNull
    private CompletableFuture<Void> triggerFetch() {
        this.fetchInProgress.set(true);
        this.lastFetchSuccessful.set(false);
        CompletionStage<Void> promise = CompletableFuture.runAsync(this::executeFetch, AsyncScheduler.getInstance().blockingExecutor());
        promise = ((CompletableFuture)promise).exceptionallyCompose(throwable -> {
            Throwable cause = throwable instanceof CompletionException ? throwable.getCause() : throwable;
            CaribouStonks.LOGGER.error("[BazaarFetcher] Fetch Bazaar failed.", cause);
            return CompletableFuture.completedFuture(null);
        });
        promise = ((CompletableFuture)promise).whenComplete((v, t) -> this.fetchInProgress.set(false));
        return promise;
    }

    private void executeFetch() {
        try (HttpResponse response = Http.request(BAZAAR_URL);){
            if (!response.success()) {
                throw new HttpResponseException(response.statusCode(), response.content());
            }
            SkyBlockBazaarReply reply = (SkyBlockBazaarReply)GsonProvider.prettyPrinting().fromJson(response.content(), SkyBlockBazaarReply.class);
            if (reply == null) {
                throw new IllegalStateException("SkyBlock API Bazaar returned null reply");
            }
            if (!reply.success) {
                String cause = reply.cause != null ? reply.cause : "?";
                throw new RuntimeException("SkyBlock API Bazaar failed. Cause: " + cause);
            }
            if (reply.products == null || reply.products.isEmpty()) {
                throw new RuntimeException("SkyBlock API Bazaar returned empty products");
            }
            this.bazaarCache.set(Map.copyOf(reply.products));
            this.lastBazaarUpdate = reply.lastUpdated > 0L ? Instant.ofEpochSecond(reply.lastUpdated) : Instant.MIN;
            this.lastFetchSuccessful.set(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class SkyBlockBazaarReply {
        public boolean success;
        public String cause;
        public long lastUpdated;
        public Map<String, Product> products;

        private SkyBlockBazaarReply() {
        }
    }
}

