/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.hypixel.fetcher;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.hypixel.election.ElectionResult;
import fr.siroz.cariboustonks.core.data.hypixel.election.Mayor;
import fr.siroz.cariboustonks.core.data.hypixel.election.Perk;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.core.scheduler.AsyncScheduler;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.util.http.Http;
import fr.siroz.cariboustonks.util.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.client.HttpResponseException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ElectionFetcher {
    private static final String ELECTION_URL = "https://api.hypixel.net/v2/resources/skyblock/election";
    private static final Duration FIRST_RETRY_DELAY = Duration.ofMinutes(1L);
    private static final int MAX_RETRIES = 10;
    private final AtomicBoolean fetchInProgress = new AtomicBoolean(false);
    private final AtomicInteger retryAttempts = new AtomicInteger(0);
    @Nullable
    private volatile ElectionResult cachedElection = null;

    public void start() {
        this.triggerFetch(false).thenRun(this.afterFetch());
    }

    @Nullable
    public ElectionResult getCachedElection() {
        return this.cachedElection;
    }

    private CompletableFuture<Void> triggerFetch(boolean force) {
        if (!force && !this.fetchInProgress.compareAndSet(false, true)) {
            CaribouStonks.LOGGER.warn("[ElectionFetcher] Skipping fetch, already in progress");
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage<Void> promise = CompletableFuture.runAsync(this::executeFetch, AsyncScheduler.getInstance().blockingExecutor());
        promise = ((CompletableFuture)promise).exceptionallyCompose(throwable -> {
            Throwable cause = throwable instanceof CompletionException ? throwable.getCause() : throwable;
            CaribouStonks.LOGGER.error("[ElectionFetcher] Fetch mayor failed (attempt {}). Cause: {}", (Object)this.retryAttempts.get(), (Object)cause);
            int attemptsSoFar = this.retryAttempts.getAndIncrement();
            if (attemptsSoFar >= 10) {
                CaribouStonks.LOGGER.error("[ElectionFetcher] Max retries reached, aborting fetch");
                this.fetchInProgress.set(false);
            } else {
                long minutes = FIRST_RETRY_DELAY.toMinutes() << attemptsSoFar;
                CaribouStonks.LOGGER.warn("[ElectionFetcher] Retrying mayor fetch in {} minutes (attempt {}/{})", new Object[]{minutes, attemptsSoFar + 1, 10});
                TickScheduler.getInstance().runLater(() -> this.triggerFetch(true).thenRun(this.afterFetch()), (int)minutes, TimeUnit.MINUTES);
            }
            return CompletableFuture.completedFuture(null);
        });
        promise = ((CompletableFuture)promise).whenComplete((v, t) -> this.fetchInProgress.set(false));
        return promise;
    }

    private void executeFetch() {
        try (HttpResponse response = Http.request(ELECTION_URL);){
            if (!response.success()) {
                throw new HttpResponseException(response.statusCode(), response.content());
            }
            String body = response.content();
            if (body == null || body.isBlank()) {
                throw new RuntimeException("SkyBlock API Election returned null or blank reply");
            }
            JsonObject root = JsonParser.parseString((String)body).getAsJsonObject();
            if (!root.has("success") || !root.get("success").getAsBoolean()) {
                throw new RuntimeException("SkyBlock API Election failed");
            }
            JsonObject mayorJson = GsonProvider.safeGetAsObject(root, "mayor");
            JsonObject ministerJson = GsonProvider.safeGetAsObject(mayorJson, "minister");
            Mayor mayor = this.parseMayor(mayorJson);
            Mayor minister = this.parseMayor(ministerJson);
            Set<Perk> mayorPerks = this.parseMayorPerks(mayorJson);
            Optional<Perk> ministerPerk = this.parseMinisterPerk(ministerJson);
            this.cachedElection = new ElectionResult(mayor, minister, mayorPerks, ministerPerk, Instant.now());
            this.retryAttempts.set(0);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private Mayor parseMayor(@Nullable JsonObject mayorObject) {
        if (mayorObject == null) {
            return Mayor.UNKNOWN;
        }
        try {
            String key = mayorObject.has("key") ? mayorObject.get("key").getAsString() : "";
            return Mayor.fromId(key);
        }
        catch (Exception ignored) {
            return Mayor.UNKNOWN;
        }
    }

    @NotNull
    private Set<Perk> parseMayorPerks(@Nullable JsonObject mayorObj) {
        if (mayorObj == null) {
            return Set.of();
        }
        try {
            HashSet<Perk> perks = new HashSet<Perk>();
            if (mayorObj.has("perks") && !mayorObj.get("perks").isJsonNull()) {
                JsonArray mayorPerks = mayorObj.getAsJsonArray("perks");
                for (JsonElement element : mayorPerks) {
                    if (!element.isJsonObject()) continue;
                    JsonObject json = element.getAsJsonObject();
                    String name = json.has("name") ? json.get("name").getAsString() : "";
                    perks.add(Perk.fromDisplayName(name));
                }
            }
            return perks;
        }
        catch (Exception ignored) {
            return Set.of();
        }
    }

    @NotNull
    private Optional<Perk> parseMinisterPerk(@Nullable JsonObject ministerObj) {
        if (ministerObj == null) {
            return Optional.empty();
        }
        try {
            JsonElement element;
            if (ministerObj.has("perk") && !ministerObj.get("perk").isJsonNull() && (element = ministerObj.get("perk")).isJsonObject()) {
                JsonObject json = element.getAsJsonObject();
                String name = json.has("name") ? json.get("name").getAsString() : "";
                return Optional.of(Perk.fromDisplayName(name));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Contract(pure=true)
    @NotNull
    private Runnable afterFetch() {
        return () -> {
            if (this.cachedElection == null) {
                CaribouStonks.LOGGER.warn("[ElectionFetcher] No election result yet");
                return;
            }
            ElectionResult result = this.cachedElection;
            if (result != null) {
                CaribouStonks.LOGGER.info("[ElectionFetcher] Current Election: Mayor: {}, Minister: {}", (Object)result.mayor().name(), (Object)result.minister().name());
            }
        };
    }
}

