/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.mod;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.mod.SkyBlockAttribute;
import fr.siroz.cariboustonks.core.data.mod.SkyBlockEnchantment;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModDataSource {
    private static final class_2960 ITEMS_MAPPING_JSON = CaribouStonks.identifier("repo/items_mapping.json");
    private final Map<String, String> minecraftIdsMapping = new HashMap<String, String>();
    private static final class_2960 ENCHANTMENTS_JSON = CaribouStonks.identifier("repo/enchantments.json");
    private final Map<String, SkyBlockEnchantment> skyBlockEnchants = new HashMap<String, SkyBlockEnchantment>();
    private static final class_2960 ATTRIBUTES_JSON = CaribouStonks.identifier("repo/attributes.json");
    private final List<SkyBlockAttribute> skyBlockAttributes = new ArrayList<SkyBlockAttribute>();
    private boolean itemsMappingError = false;
    private boolean enchantmentsError = false;
    private boolean attributesError = false;

    @ApiStatus.Internal
    public ModDataSource() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> this.loadModData(client).thenRun(this::checkResults));
    }

    @Nullable
    public String getMinecraftId(@NotNull String hypixelMaterial) {
        if (this.minecraftIdsMapping.isEmpty()) {
            return null;
        }
        return this.minecraftIdsMapping.get(hypixelMaterial);
    }

    public boolean containsItem(@NotNull String hypixelMaterial) {
        if (this.minecraftIdsMapping.isEmpty()) {
            return false;
        }
        return this.minecraftIdsMapping.containsKey(hypixelMaterial);
    }

    public boolean isItemsMappingError() {
        return this.itemsMappingError;
    }

    @Nullable
    public SkyBlockEnchantment getSkyBlockEnchantment(@NotNull String id) {
        if (this.skyBlockEnchants.isEmpty()) {
            return null;
        }
        return this.skyBlockEnchants.get(id);
    }

    @Nullable
    public SkyBlockAttribute getAttributeBySkyBlockId(@Nullable String skyBlockId) {
        if (skyBlockId == null || skyBlockId.isEmpty() || this.skyBlockAttributes.isEmpty()) {
            return null;
        }
        for (SkyBlockAttribute attribute : this.skyBlockAttributes) {
            if (!attribute.skyBlockApiId().equals(skyBlockId)) continue;
            return attribute;
        }
        return null;
    }

    @Nullable
    public SkyBlockAttribute getAttributeById(@Nullable String id) {
        if (id == null || id.isEmpty() || this.skyBlockAttributes.isEmpty()) {
            return null;
        }
        for (SkyBlockAttribute attribute : this.skyBlockAttributes) {
            if (!attribute.id().equals(id)) continue;
            return attribute;
        }
        return null;
    }

    @Nullable
    public SkyBlockAttribute getAttributeByShardName(@Nullable String name) {
        if (name == null || name.isEmpty() || this.skyBlockAttributes.isEmpty()) {
            return null;
        }
        name = name.replace(" Shard", "");
        for (SkyBlockAttribute attribute : this.skyBlockAttributes) {
            if (!attribute.shardName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    @NotNull
    private CompletableFuture<Void> loadModData(class_310 client) {
        CompletableFuture<Void> itemsMappingFuture = CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = client.method_1478().openAsReader(ITEMS_MAPPING_JSON);){
                JsonObject jsonMapping = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (Map.Entry entry : jsonMapping.entrySet()) {
                    this.minecraftIdsMapping.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
            }
            catch (Exception ex) {
                this.itemsMappingError = true;
                CaribouStonks.LOGGER.error("[ModDataSource] There was an error while loading items mapping", (Throwable)ex);
            }
        });
        CompletableFuture<Void> enchantmentsFuture = CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = client.method_1478().openAsReader(ENCHANTMENTS_JSON);){
                JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    JsonObject jsonEnchantment = element.getAsJsonObject();
                    SkyBlockEnchantment enchantment = this.getSkyBlockEnchantment(jsonEnchantment);
                    this.skyBlockEnchants.put(enchantment.id(), enchantment);
                }
            }
            catch (Throwable throwable) {
                this.enchantmentsError = true;
                CaribouStonks.LOGGER.error("[ModDataSource] There was an error while loading enchantments", throwable);
            }
        });
        CompletableFuture<Void> attributesFuture = CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = client.method_1478().openAsReader(ATTRIBUTES_JSON);){
                JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    JsonObject jsonAttribute = element.getAsJsonObject();
                    SkyBlockAttribute attribute = this.getSkyBlockAttribute(jsonAttribute);
                    this.skyBlockAttributes.add(attribute);
                }
            }
            catch (Throwable throwable) {
                this.attributesError = true;
                CaribouStonks.LOGGER.error("[ModDataSource] There was an error while loading attributes", throwable);
            }
        });
        return CompletableFuture.allOf(itemsMappingFuture, enchantmentsFuture, attributesFuture);
    }

    private void checkResults() {
        if (!this.itemsMappingError && !this.minecraftIdsMapping.isEmpty()) {
            CaribouStonks.LOGGER.info("[ModDataSource] Loaded {} items in the items mapping", (Object)this.minecraftIdsMapping.size());
        }
        if (!this.enchantmentsError && !this.skyBlockEnchants.isEmpty()) {
            CaribouStonks.LOGGER.info("[ModDataSource] Loaded {} enchantments", (Object)this.skyBlockEnchants.size());
        }
        if (!this.attributesError && !this.skyBlockAttributes.isEmpty()) {
            CaribouStonks.LOGGER.info("[ModDataSource] Loaded {} attributes", (Object)this.skyBlockAttributes.size());
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    private SkyBlockEnchantment getSkyBlockEnchantment(@NotNull JsonObject jsonEnchantment) {
        return new SkyBlockEnchantment(jsonEnchantment.get("id").getAsString(), jsonEnchantment.get("name").getAsString(), jsonEnchantment.get("maxLevel").getAsInt(), jsonEnchantment.has("goodLevel") ? OptionalInt.of(jsonEnchantment.get("goodLevel").getAsInt()) : OptionalInt.empty());
    }

    @Contract(value="_ -> new")
    @NotNull
    private SkyBlockAttribute getSkyBlockAttribute(@NotNull JsonObject jsonAttribute) {
        return new SkyBlockAttribute(jsonAttribute.get("name").getAsString(), jsonAttribute.get("shardName").getAsString(), jsonAttribute.get("id").getAsString(), jsonAttribute.get("skyBlockApiId").getAsString());
    }
}

