/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.scheduler;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.util.Ticks;
import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public final class TickScheduler {
    private static TickScheduler instance;
    private int currentTick = 0;
    private final AbstractInt2ObjectMap<List<Runnable>> tasks = new Int2ObjectOpenHashMap();
    private final AtomicInteger taskIdGenerator = new AtomicInteger(0);

    private TickScheduler() {
        ClientTickEvents.END_CLIENT_TICK.register(this::processTick);
    }

    public static TickScheduler getInstance() {
        return instance == null ? (instance = new TickScheduler()) : instance;
    }

    public boolean cancelTask(int taskId) {
        boolean found = false;
        for (List taskList : this.tasks.values()) {
            Iterator iterator = taskList.iterator();
            while (iterator.hasNext()) {
                Runnable task = (Runnable)iterator.next();
                if (!(task instanceof ScheduledTask)) continue;
                ScheduledTask scheduledTask = (ScheduledTask)task;
                if (scheduledTask.id != taskId) continue;
                scheduledTask.setCancelled(true);
                iterator.remove();
                found = true;
            }
        }
        return found;
    }

    public void runLater(@NotNull Runnable task, int delay, @NotNull TimeUnit delayUnit) {
        this.runLater(task, Ticks.from(Math.max(0, delay), delayUnit));
    }

    public void runLater(@NotNull Runnable task, int delay) {
        ScheduledTask scheduledTask = new ScheduledTask(task);
        scheduledTask.setId(this.taskIdGenerator.incrementAndGet());
        this.scheduleTask(scheduledTask, this.currentTick + Math.max(0, delay));
    }

    public int runRepeating(@NotNull Runnable task, int interval, @NotNull TimeUnit intervalUnit) {
        return this.runRepeating(task, Ticks.from(Math.max(1, interval), intervalUnit));
    }

    public int runRepeating(Runnable task, int interval) {
        ScheduledTask scheduledTask = new ScheduledTask(task, Math.max(1, interval), TaskType.REPEATING);
        scheduledTask.setId(this.taskIdGenerator.incrementAndGet());
        return this.scheduleTask(scheduledTask, this.currentTick);
    }

    private int scheduleTask(ScheduledTask scheduledTask, int schedule) {
        if (this.tasks.containsKey(schedule)) {
            ((List)this.tasks.get(schedule)).add(scheduledTask);
        } else {
            ArrayList<ScheduledTask> list = new ArrayList<ScheduledTask>();
            list.add(scheduledTask);
            this.tasks.put(schedule, list);
        }
        return scheduledTask.id;
    }

    void processTick(class_310 client) {
        if (this.tasks.containsKey(this.currentTick)) {
            List currentTickTasks = (List)this.tasks.get(this.currentTick);
            for (int i = 0; i < currentTickTasks.size(); ++i) {
                Runnable task = (Runnable)currentTickTasks.get(i);
                if (this.runTask(task)) continue;
                ((List)this.tasks.computeIfAbsent(this.currentTick + 1, key -> new ArrayList())).add(task);
            }
            this.tasks.remove(this.currentTick);
        }
        ++this.currentTick;
    }

    private boolean runTask(@NotNull Runnable task) {
        try {
            task.run();
        }
        catch (Throwable throwable) {
            if (task instanceof ScheduledTask) {
                ScheduledTask scheduledTask = (ScheduledTask)task;
                CaribouStonks.LOGGER.error("[TickScheduler] Error while running task #{}", (Object)scheduledTask.id, (Object)throwable);
            }
            return false;
        }
        return true;
    }

    private static class ScheduledTask
    implements Runnable {
        private final Runnable task;
        private final int interval;
        private final TaskType taskType;
        private int id = -1;
        private boolean cancelled = false;

        ScheduledTask(Runnable task) {
            this(task, 0, TaskType.SINGLE);
        }

        ScheduledTask(Runnable task, int interval, TaskType taskType) {
            this.task = task;
            this.interval = interval;
            this.taskType = taskType;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                this.task.run();
                if (this.taskType == TaskType.REPEATING) {
                    if (class_310.method_1551() != null && !RenderSystem.isOnRenderThread()) {
                        class_310.method_1551().method_63588(() -> instance.scheduleTask(this, TickScheduler.instance.currentTick + this.interval));
                    } else {
                        instance.scheduleTask(this, TickScheduler.instance.currentTick + this.interval);
                    }
                }
            }
        }
    }

    private static enum TaskType {
        SINGLE,
        REPEATING;

    }
}

