/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.skyblock;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.hypixel.item.Rarity;
import fr.siroz.cariboustonks.core.data.mod.SkyBlockAttribute;
import fr.siroz.cariboustonks.util.StonksUtils;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeAPI {
    public static final int MAX_LEVEL = 10;
    public static final String HUNTING_BOX = "Hunting Box";
    public static final String ATTRIBUTE_MENU = "Attribute Menu";
    public static final String FUSION_BOX = "Fusion Box";
    public static final String SHARD_FUSION = "Shard Fusion";
    public static final Pattern SHARD_GUI_PATTERN = Pattern.compile("(Hunting Box|Attribute Menu)");
    public static final Pattern SOURCE_PATTERN = Pattern.compile("Source: (?<shardName>[A-Za-z ]+?) Shard \\((?<id>[CUREL]\\d+)\\)");
    public static final Pattern RARITY_AND_ID_PATTERN = Pattern.compile("(COMMON|UNCOMMON|RARE|EPIC|LEGENDARY).*?SHARD \\(ID ([CUREL]\\d+)\\)");
    private static final Map<Rarity, Int2IntMap> RARITY_2_LEVELS = new EnumMap<Rarity, Int2IntMap>(Rarity.class);

    private AttributeAPI() {
    }

    public static String getSkyBlockApiIdFromNewShard(@NotNull String fallback, class_1799 item, List<class_2561> lines) {
        String title;
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (!fallback.isEmpty() || currentScreen == null) {
            return fallback;
        }
        String string = title = currentScreen.method_25440().getString();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HUNTING_BOX, ATTRIBUTE_MENU, FUSION_BOX, SHARD_FUSION}, (Object)string, n)) {
            case 0: {
                String name = ((class_2561)item.method_58695(class_9334.field_49631, (Object)class_2561.method_43473())).getString();
                SkyBlockAttribute attribute = CaribouStonks.core().getModDataSource().getAttributeByShardName(name);
                return attribute != null ? attribute.skyBlockApiId() : fallback;
            }
            case 1: {
                String id = null;
                for (class_2561 line : lines) {
                    Matcher attributeIdMatcher;
                    String lineText = line.getString();
                    if (lineText.isEmpty() || !(attributeIdMatcher = SOURCE_PATTERN.matcher(lineText)).matches()) continue;
                    id = attributeIdMatcher.group("id");
                    break;
                }
                return AttributeAPI.getAttributeId(id, fallback);
            }
            case 2: 
            case 3: {
                String id = null;
                for (class_2561 line : lines) {
                    Matcher attributeRarityAndIdMatcher;
                    String lineText = line.getString();
                    if (lineText.isEmpty() || !(attributeRarityAndIdMatcher = RARITY_AND_ID_PATTERN.matcher(lineText)).matches()) continue;
                    id = attributeRarityAndIdMatcher.group(2);
                    break;
                }
                return AttributeAPI.getAttributeId(id, fallback);
            }
        }
        return fallback;
    }

    private static String getAttributeId(@Nullable String id, @NotNull String fallback) {
        SkyBlockAttribute attribute = CaribouStonks.core().getModDataSource().getAttributeById(id);
        return attribute != null ? attribute.skyBlockApiId() : fallback;
    }

    public static int getShardsUntilMax(Rarity rarity, int level) {
        if (level == 10) {
            return 0;
        }
        Int2IntMap level2Count = RARITY_2_LEVELS.get((Object)rarity);
        if (level2Count == null) {
            return -1;
        }
        int currentShardCount = level2Count.getOrDefault(level, -1);
        if (currentShardCount == -1) {
            return -1;
        }
        int maxShardCount = level2Count.getOrDefault(10, -1);
        if (maxShardCount == -1) {
            return -1;
        }
        return maxShardCount - currentShardCount;
    }

    static {
        RARITY_2_LEVELS.put(Rarity.COMMON, (Int2IntMap)StonksUtils.make(new Int2IntArrayMap(), map -> {
            map.put(1, 1);
            map.put(2, 4);
            map.put(3, 9);
            map.put(4, 15);
            map.put(5, 22);
            map.put(6, 30);
            map.put(7, 40);
            map.put(8, 54);
            map.put(9, 72);
            map.put(10, 96);
        }));
        RARITY_2_LEVELS.put(Rarity.UNCOMMON, (Int2IntMap)StonksUtils.make(new Int2IntArrayMap(), map -> {
            map.put(1, 1);
            map.put(2, 3);
            map.put(3, 6);
            map.put(4, 10);
            map.put(5, 15);
            map.put(6, 21);
            map.put(7, 28);
            map.put(8, 36);
            map.put(9, 48);
            map.put(10, 64);
        }));
        RARITY_2_LEVELS.put(Rarity.RARE, (Int2IntMap)StonksUtils.make(new Int2IntArrayMap(), map -> {
            map.put(1, 1);
            map.put(2, 3);
            map.put(3, 6);
            map.put(4, 9);
            map.put(5, 13);
            map.put(6, 17);
            map.put(7, 22);
            map.put(8, 28);
            map.put(9, 39);
            map.put(10, 48);
        }));
        RARITY_2_LEVELS.put(Rarity.EPIC, (Int2IntMap)StonksUtils.make(new Int2IntArrayMap(), map -> {
            map.put(1, 1);
            map.put(2, 2);
            map.put(3, 4);
            map.put(4, 6);
            map.put(5, 9);
            map.put(6, 12);
            map.put(7, 16);
            map.put(8, 20);
            map.put(9, 25);
            map.put(10, 32);
        }));
        RARITY_2_LEVELS.put(Rarity.LEGENDARY, (Int2IntMap)StonksUtils.make(new Int2IntArrayMap(), map -> {
            map.put(1, 1);
            map.put(2, 2);
            map.put(3, 3);
            map.put(4, 5);
            map.put(5, 7);
            map.put(6, 9);
            map.put(7, 12);
            map.put(8, 15);
            map.put(9, 19);
            map.put(10, 24);
        }));
    }
}

