/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.skyblock;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.hypixel.election.ElectionResult;
import fr.siroz.cariboustonks.core.data.hypixel.election.Mayor;
import fr.siroz.cariboustonks.core.data.hypixel.election.Perk;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.util.DeveloperTools;
import fr.siroz.cariboustonks.util.ScoreboardUtils;
import fr.siroz.cariboustonks.util.StonksUtils;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SkyBlockAPI {
    private static final class_310 CLIENT = class_310.method_1551();
    private static boolean onHypixelState = false;
    private static boolean onSkyBlockState = false;
    private static IslandType islandType = IslandType.UNKNOWN;
    private static String gameType = "";

    private SkyBlockAPI() {
    }

    public static boolean isOnSkyBlock() {
        return onSkyBlockState;
    }

    public static IslandType getIsland() {
        return islandType;
    }

    public static boolean isOnIslands(IslandType ... islandTypes) {
        if (islandTypes.length == 0) {
            return false;
        }
        if (islandTypes.length == 1) {
            return islandTypes[0] == islandType;
        }
        for (IslandType type : islandTypes) {
            if (type != islandType) continue;
            return true;
        }
        return false;
    }

    public static boolean isMayorOrMinister(@NotNull Mayor mayor) {
        return SkyBlockAPI.isMayorOrMinister(mayor, null);
    }

    public static boolean isMayorOrMinister(@NotNull Mayor mayor, @Nullable Perk perk) {
        ElectionResult result = CaribouStonks.core().getHypixelDataSource().getElection();
        if (result == null) {
            return false;
        }
        if (perk == null) {
            return mayor == result.mayor() || mayor == result.minister();
        }
        if (mayor == result.mayor()) {
            Set<Perk> mayorPerks = result.mayorPerks();
            return !mayorPerks.isEmpty() && mayorPerks.contains((Object)perk);
        }
        if (mayor == result.minister()) {
            Optional<Perk> opt = result.ministerPerk();
            return opt.isPresent() && opt.get() == perk;
        }
        return false;
    }

    @NotNull
    public static Optional<String> getArea() {
        return Optional.ofNullable(ScoreboardUtils.getIslandArea());
    }

    @ApiStatus.Internal
    public static String getGameType() {
        return gameType;
    }

    @ApiStatus.Internal
    public static void update() {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if ((SkyBlockAPI.CLIENT.field_1687 == null || CLIENT.method_1542()) && fabricLoader.isDevelopmentEnvironment()) {
            onSkyBlockState = true;
        }
        if (fabricLoader.isDevelopmentEnvironment() || StonksUtils.isConnectedToHypixel()) {
            if (!StonksUtils.isConnectedToHypixel()) {
                onHypixelState = true;
            }
        } else if (onHypixelState) {
            onHypixelState = false;
        }
    }

    @ApiStatus.Internal
    public static void handleLocationUpdate(@Nullable Boolean onHypixel, @Nullable Boolean onSkyBlock, @Nullable String gameTypeFromServer, @Nullable IslandType islandTypeFromMode) {
        if (onHypixel != null) {
            onHypixelState = onHypixel;
        }
        if (onSkyBlock != null) {
            onSkyBlockState = onSkyBlock;
        }
        if (gameTypeFromServer != null) {
            gameType = gameTypeFromServer;
        }
        if (islandTypeFromMode != null) {
            islandType = islandTypeFromMode;
        }
        if (DeveloperTools.isInDevelopment()) {
            CaribouStonks.LOGGER.info("[SkyBlockAPI] Updated: {}, {}, {}, {}", new Object[]{onHypixelState, onSkyBlockState, gameType, islandType.name()});
        }
    }
}

