/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.chat.ChatColorationFeature;
import fr.siroz.cariboustonks.feature.chat.ChatPositionFeature;
import fr.siroz.cariboustonks.feature.chat.CopyChatMessageFeature;
import fr.siroz.cariboustonks.feature.combat.CocoonedWarningFeature;
import fr.siroz.cariboustonks.feature.combat.LowHealthWarningFeature;
import fr.siroz.cariboustonks.feature.diana.MythologicalRitualFeature;
import fr.siroz.cariboustonks.feature.fishing.HotspotFeature;
import fr.siroz.cariboustonks.feature.fishing.radar.HotspotRadarFeature;
import fr.siroz.cariboustonks.feature.foraging.BreakTreeAnimationFeature;
import fr.siroz.cariboustonks.feature.foraging.TreeOverlayFeature;
import fr.siroz.cariboustonks.feature.garden.MouseLockFeature;
import fr.siroz.cariboustonks.feature.garden.pest.PestFinderFeature;
import fr.siroz.cariboustonks.feature.hunting.AttributeInfoTooltipFeature;
import fr.siroz.cariboustonks.feature.item.ColoredEnchantmentFeature;
import fr.siroz.cariboustonks.feature.item.ScrollableTooltipFeature;
import fr.siroz.cariboustonks.feature.item.TooltipDecoratorFeature;
import fr.siroz.cariboustonks.feature.keyshortcut.KeyShortcutFeature;
import fr.siroz.cariboustonks.feature.misc.HighlightMobFeature;
import fr.siroz.cariboustonks.feature.misc.PartyCommandFeature;
import fr.siroz.cariboustonks.feature.misc.REISearchBarCalculatorFeature;
import fr.siroz.cariboustonks.feature.misc.StopPickobulusAbilityFeature;
import fr.siroz.cariboustonks.feature.reminders.BoosterCookieReminderFeature;
import fr.siroz.cariboustonks.feature.reminders.ChocolateLimitReminderFeature;
import fr.siroz.cariboustonks.feature.reminders.EnchantedCloakReminderFeature;
import fr.siroz.cariboustonks.feature.reminders.ForgeReminderFeature;
import fr.siroz.cariboustonks.feature.reminders.UbikCubeReminderFeature;
import fr.siroz.cariboustonks.feature.slayer.HighlightSlayerMobFeature;
import fr.siroz.cariboustonks.feature.slayer.SlayerCocoonedWarningFeature;
import fr.siroz.cariboustonks.feature.slayer.SlayerStatsFeature;
import fr.siroz.cariboustonks.feature.slayer.boss.TarantulaBossFeature;
import fr.siroz.cariboustonks.feature.stonks.StonksCommandFeature;
import fr.siroz.cariboustonks.feature.stonks.StonksFeature;
import fr.siroz.cariboustonks.feature.stonks.tooltips.auction.AuctionLowestBinTooltipFeature;
import fr.siroz.cariboustonks.feature.stonks.tooltips.bazaar.BazaarPriceTooltipFeature;
import fr.siroz.cariboustonks.feature.ui.AbiphoneFavoriteContactFeature;
import fr.siroz.cariboustonks.feature.ui.SelectedPetHighlightFeature;
import fr.siroz.cariboustonks.feature.ui.ZoomFeature;
import fr.siroz.cariboustonks.feature.ui.hud.DayHud;
import fr.siroz.cariboustonks.feature.ui.hud.FpsHud;
import fr.siroz.cariboustonks.feature.ui.hud.PingHud;
import fr.siroz.cariboustonks.feature.ui.hud.TpsHud;
import fr.siroz.cariboustonks.feature.ui.overlay.EtherWarpOverlayFeature;
import fr.siroz.cariboustonks.feature.ui.overlay.GyrokineticOverlayFeature;
import fr.siroz.cariboustonks.feature.vanilla.MuteVanillaSoundFeature;
import fr.siroz.cariboustonks.feature.waypoints.WaypointFeature;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class Features {
    private static final Set<Feature> FEATURES = new LinkedHashSet<Feature>();
    private static final Map<Class<? extends Feature>, Feature> FEATURE_INSTANCES = new ConcurrentHashMap<Class<? extends Feature>, Feature>();

    public Features() {
        CaribouStonks.LOGGER.info("[FeatureManager] Loading..");
        this.registerFeature(new ChatColorationFeature());
        this.registerFeature(new ChatPositionFeature());
        this.registerFeature(new CopyChatMessageFeature());
        this.registerFeature(new CocoonedWarningFeature());
        this.registerFeature(new LowHealthWarningFeature());
        this.registerFeature(new MythologicalRitualFeature());
        this.registerFeature(new HotspotFeature());
        this.registerFeature(new HotspotRadarFeature());
        this.registerFeature(new BreakTreeAnimationFeature());
        this.registerFeature(new TreeOverlayFeature());
        this.registerFeature(new PestFinderFeature());
        this.registerFeature(new MouseLockFeature());
        this.registerFeature(new AttributeInfoTooltipFeature(3));
        this.registerFeature(new ColoredEnchantmentFeature());
        this.registerFeature(new ScrollableTooltipFeature());
        this.registerFeature(new TooltipDecoratorFeature());
        this.registerFeature(new KeyShortcutFeature());
        this.registerFeature(new SelectedPetHighlightFeature());
        this.registerFeature(new BoosterCookieReminderFeature());
        this.registerFeature(new ChocolateLimitReminderFeature());
        this.registerFeature(new EnchantedCloakReminderFeature());
        this.registerFeature(new ForgeReminderFeature());
        this.registerFeature(new UbikCubeReminderFeature());
        this.registerFeature(new HighlightSlayerMobFeature());
        this.registerFeature(new SlayerCocoonedWarningFeature());
        this.registerFeature(new SlayerStatsFeature());
        this.registerFeature(new TarantulaBossFeature());
        this.registerFeature(new StonksCommandFeature());
        this.registerFeature(new StonksFeature());
        this.registerFeature(new BazaarPriceTooltipFeature(1));
        this.registerFeature(new AuctionLowestBinTooltipFeature(2));
        this.registerFeature(new AbiphoneFavoriteContactFeature(0));
        this.registerFeature(new ZoomFeature());
        this.registerFeature(new FpsHud());
        this.registerFeature(new PingHud());
        this.registerFeature(new TpsHud());
        this.registerFeature(new DayHud());
        this.registerFeature(new EtherWarpOverlayFeature());
        this.registerFeature(new GyrokineticOverlayFeature());
        this.registerFeature(new WaypointFeature());
        this.registerFeature(new HighlightMobFeature());
        this.registerFeature(new PartyCommandFeature());
        this.registerFeature(new REISearchBarCalculatorFeature());
        this.registerFeature(new StopPickobulusAbilityFeature());
        this.registerFeature(new MuteVanillaSoundFeature());
        CaribouStonks.LOGGER.info("{} features are now loaded and ready", (Object)this.getFeatures().size());
    }

    private void registerFeature(@NotNull Feature feature) {
        FEATURES.add(feature);
        FEATURE_INSTANCES.put(feature.getClass(), feature);
        CaribouStonks.managers().handleFeatureRegistration(feature);
    }

    @Contract(value=" -> new")
    @NotNull
    public @Unmodifiable Set<Feature> getFeatures() {
        return new LinkedHashSet<Feature>(FEATURES);
    }

    public <T extends Feature> T getFeature(@NotNull Class<T> featureClass) {
        return (T)FEATURE_INSTANCES.get(featureClass);
    }
}

