/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.combat;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.event.SkyBlockEvents;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.slayer.SlayerCocoonedWarningFeature;
import fr.siroz.cariboustonks.manager.slayer.SlayerManager;
import fr.siroz.cariboustonks.manager.slayer.SlayerType;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.render.WorldRenderUtils;
import fr.siroz.cariboustonks.util.render.WorldRendererProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class CocoonedWarningFeature
extends Feature
implements WorldRendererProvider {
    private static final long WORLD_CHANGE_THRESHOLD = 10000L;
    private static final double MAX_ARMORSTAND_PAIR_DISTANCE_SQ = 4.0;
    private static final double MAX_PLAYER_COCOON_DISTANCE_SQ = 225.0;
    private final BooleanSupplier configSoundEnabled = () -> ConfigManager.getConfig().combat.cocoonedMob.cocoonedWarningSound;
    private final BooleanSupplier configTitleEnabled = () -> ConfigManager.getConfig().combat.cocoonedMob.cocoonedWarningTitle;
    private final BooleanSupplier configBeamEnabled = () -> ConfigManager.getConfig().combat.cocoonedMob.cocoonedWarningBeam;
    private final SlayerManager slayerManager;
    private final Deque<class_1531> chain = new ArrayDeque<class_1531>();
    private final List<class_2338> cocoonPositions = new ArrayList<class_2338>();
    private long lastWorldChange = 0L;
    private boolean canBeTriggered = false;

    public CocoonedWarningFeature() {
        this.slayerManager = CaribouStonks.managers().getManager(SlayerManager.class);
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register(this::onChangeWorld);
        SkyBlockEvents.ISLAND_CHANGE.register(this::onChangeIsland);
        NetworkEvents.ARMORSTAND_UPDATE_PACKET.register(this::onUpdateArmorStand);
        WorldEvents.ARMORSTAND_REMOVED.register(this::onRemoveArmorStand);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::render);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && this.canBeTriggered && !this.slayerManager.isInQuestWithBoss(SlayerType.SPIDER) && !SlayerCocoonedWarningFeature.isCocoonedBoss() && ConfigManager.getConfig().combat.cocoonedMob.cocoonedWarning;
    }

    private void onChangeWorld(class_310 _mc, class_638 _world) {
        this.lastWorldChange = System.currentTimeMillis();
        this.chain.clear();
        this.cocoonPositions.clear();
    }

    private void onChangeIsland(@NotNull IslandType islandType) {
        this.canBeTriggered = islandType != IslandType.DUNGEON && islandType != IslandType.KUUDRA_HOLLOW && islandType != IslandType.THE_RIFT;
    }

    private void onUpdateArmorStand(@NotNull class_1531 armorStandEntity, boolean equipment) {
        if (equipment || System.currentTimeMillis() - this.lastWorldChange < 10000L) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.matchesCocoonCriteria(armorStandEntity)) {
            return;
        }
        for (class_1531 as : this.chain) {
            if (as.method_5628() != armorStandEntity.method_5628()) continue;
            return;
        }
        this.chain.removeIf(a -> a.method_31481() || a.method_29504());
        if (this.chain.isEmpty()) {
            this.chain.addLast(armorStandEntity);
            return;
        }
        boolean closeToAny = false;
        for (class_1531 as : this.chain) {
            if (!(as.method_5858((class_1297)armorStandEntity) <= 4.0)) continue;
            closeToAny = true;
            break;
        }
        if (closeToAny) {
            this.chain.addLast(armorStandEntity);
            while (this.chain.size() > 3) {
                this.chain.removeFirst();
            }
            if (this.chain.size() == 3) {
                this.onMobCocooned(this.chain.element().method_24515());
                this.chain.clear();
            }
        } else {
            this.chain.clear();
            this.chain.addLast(armorStandEntity);
        }
    }

    private void onRemoveArmorStand(@NotNull class_1531 armorStand) {
        this.chain.removeIf(a -> a.method_5628() == armorStand.method_5628());
    }

    @Override
    public void render(WorldRenderContext context) {
        for (class_2338 pos : this.cocoonPositions) {
            class_2338 finalPos = pos.method_10062().method_10069(0, -4, 0);
            WorldRenderUtils.renderBeaconBeam(context, finalPos, Colors.RED);
        }
    }

    private void onMobCocooned(class_2338 pos) {
        Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)"A mob has been cocooned!").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        if (this.configSoundEnabled.getAsBoolean()) {
            Client.playSound(class_3417.field_15203, 1.0f, 1.0f);
        }
        if (this.configTitleEnabled.getAsBoolean()) {
            Client.showTitle((class_2561)class_2561.method_43470((String)"Cocooned!").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), 0, 27, 0);
        }
        if (this.configBeamEnabled.getAsBoolean() && pos != null) {
            this.cocoonPositions.add(pos);
            class_2338 finalPos = pos;
            TickScheduler.getInstance().runLater(() -> this.cocoonPositions.remove(finalPos), 4, TimeUnit.SECONDS);
        }
    }

    private boolean matchesCocoonCriteria(@NotNull class_1531 as) {
        if (as.method_5807() || !as.method_6084(class_1304.field_6169)) {
            return false;
        }
        String headTexture = ItemUtils.getHeadTexture(as.method_6118(class_1304.field_6169));
        if (headTexture.isBlank()) {
            return false;
        }
        if (CocoonedWarningFeature.CLIENT.field_1724 != null && CocoonedWarningFeature.CLIENT.field_1724.method_19538().method_1025(as.method_19538()) > 225.0) {
            return false;
        }
        return headTexture.equals("eyJ0aW1lc3RhbXAiOjE1ODMxMjMyODkwNTMsInByb2ZpbGVJZCI6IjkxZjA0ZmU5MGYzNjQzYjU4ZjIwZTMzNzVmODZkMzllIiwicHJvZmlsZU5hbWUiOiJTdG9ybVN0b3JteSIsInNpZ25hdHVyZVJlcXVpcmVkIjp0cnVlLCJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGNlYjBlZDhmYzIyNzJiM2QzZDgyMDY3NmQ1MmEzOGU3YjJlOGRhOGM2ODdhMjMzZTBkYWJhYTE2YzBlOTZkZiJ9fX0=");
    }
}

