/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.fishing.radar;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.fishing.radar.HotspotRadarRenderer;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.math.bezier.ParticlePathPredictor;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2675;
import net.minecraft.class_9322;
import org.jetbrains.annotations.Nullable;

public class HotspotRadarFeature
extends Feature {
    private static final String HOTSPOT_RADAR_ITEM_ID = "HOTSPOT_RADAR";
    private final HotspotRadarRenderer renderer;
    private final ParticlePathPredictor predictor = new ParticlePathPredictor(3);
    private class_243 guessPosition = null;
    private long lastUsedRadar = 0L;

    public HotspotRadarFeature() {
        UseItemCallback.EVENT.register(this::onUseItem);
        NetworkEvents.PARTICLE_RECEIVED_PACKET.register(this::onParticleReceived);
        WorldEvents.JOIN.register(world -> this.reset());
        this.renderer = new HotspotRadarRenderer(this);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::render);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().fishing.hotspotRadarGuess && SkyBlockAPI.isOnIslands(IslandType.CRIMSON_ISLE, IslandType.BACKWATER_BAYOU);
    }

    @Nullable
    class_243 getGuessPosition() {
        return this.guessPosition;
    }

    public void reset() {
        this.predictor.reset();
        this.guessPosition = null;
        this.lastUsedRadar = 0L;
    }

    private class_1269 onUseItem(class_1657 player, class_1937 _world, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.isEnabled() && stack != null && !stack.method_7960() && HOTSPOT_RADAR_ITEM_ID.equals(ItemUtils.getSkyBlockItemId((class_9322)stack))) {
            this.predictor.reset();
            this.guessPosition = null;
            this.lastUsedRadar = System.currentTimeMillis();
        }
        return class_1269.field_5811;
    }

    private void onParticleReceived(class_2675 particle) {
        if (!this.isEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUsedRadar > 2000L) {
            return;
        }
        if (class_2398.field_11240.equals(particle.method_11551().method_10295()) && particle.method_11545() == 1 && particle.method_11543() == 0.0f) {
            class_243 position = new class_243(particle.method_11544(), particle.method_11547(), particle.method_11546());
            this.handleParticle(position);
        }
    }

    private void render(WorldRenderContext context) {
        this.renderer.render(context);
    }

    private void handleParticle(class_243 position) {
        if (this.predictor.isEmpty()) {
            this.predictor.addPoint(position);
            return;
        }
        class_243 lastPoint = this.predictor.getLastPoint();
        if (lastPoint == null) {
            return;
        }
        double distance = lastPoint.method_1022(position);
        if (distance == 0.0 || distance > 3.0) {
            return;
        }
        this.predictor.addPoint(position);
        class_243 solved = this.predictor.solve();
        if (solved == null) {
            return;
        }
        this.guessPosition = solved;
    }
}

