/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.garden.pest;

import fr.siroz.cariboustonks.feature.garden.pest.PestFinderFeature;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.render.Renderer;
import fr.siroz.cariboustonks.util.render.WorldRenderUtils;
import fr.siroz.cariboustonks.util.render.WorldRendererProvider;
import fr.siroz.cariboustonks.util.shape.Cuboid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

final class PlotInfestedRenderer
implements WorldRendererProvider {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final int GREEN = Colors.GREEN.asInt();
    private static final int YELLOW = Colors.YELLOW.asInt();
    private static final int PLOT_SIZE = 96;
    private static final int MIN_PLOT_Y = 66;
    private static final int MAX_PLOT_Y = 100;
    private static final List<List<Integer>> PLOTS_IDS = Arrays.asList(Arrays.asList(21, 13, 9, 14, 22), Arrays.asList(15, 5, 1, 6, 16), Arrays.asList(10, 2, 0, 3, 11), Arrays.asList(17, 7, 4, 8, 18), Arrays.asList(23, 19, 12, 20, 24));
    private final PestFinderFeature pestFinderFeature;
    private final List<Plot> plots = new ArrayList<Plot>();

    PlotInfestedRenderer(PestFinderFeature pestFinderFeature) {
        this.pestFinderFeature = pestFinderFeature;
        this.createPlots();
    }

    @NotNull
    public Optional<Plot> getPlot(int id) {
        return this.plots.stream().filter(plot -> plot.id == id).findFirst();
    }

    private void createPlots() {
        for (int i = 0; i < PLOTS_IDS.size(); ++i) {
            List<Integer> row = PLOTS_IDS.get(i);
            for (int x = 0; x < row.size(); ++x) {
                int id = row.get(x);
                double minX = (x - 2) * 96 - 48;
                double minZ = (i - 2) * 96 - 48;
                double maxX = (x - 2) * 96 + 48;
                double maxZ = (i - 2) * 96 + 48;
                Cuboid cuboid = new Cuboid(new class_2338((int)minX, 0, (int)minZ), new class_2338((int)maxX, 256, (int)maxZ));
                this.plots.add(new Plot(id, cuboid, cuboid.getCenter().method_46558()));
            }
        }
    }

    @Override
    public void render(WorldRenderContext context) {
        if (PlotInfestedRenderer.CLIENT.field_1724 == null || PlotInfestedRenderer.CLIENT.field_1687 == null) {
            return;
        }
        if (!this.pestFinderFeature.isEnabled()) {
            return;
        }
        if (!this.pestFinderFeature.highlightInfestedPlots()) {
            return;
        }
        if (this.pestFinderFeature.getInfestedPlots().isEmpty()) {
            return;
        }
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        double cameraX = cameraPos.field_1352;
        double cameraY = cameraPos.field_1351;
        double cameraZ = cameraPos.field_1350;
        class_287 buffer = Renderer.getInstance().getBuffer(class_10799.field_56836, 1.5f);
        class_4587 stack = context.matrixStack();
        assert (stack != null);
        stack.method_22903();
        class_4587.class_4665 entry = stack.method_23760();
        for (int id : this.pestFinderFeature.getInfestedPlots()) {
            int i;
            Optional<Plot> plotOptional = this.getPlot(id);
            if (plotOptional.isEmpty()) continue;
            Plot plot = plotOptional.get();
            WorldRenderUtils.renderText(context, (class_2561)class_2561.method_43470((String)"Plot").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)(" " + plot.id)).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})), plot.center.method_1023(0.0, 40.0, 0.0), 5.0f, true);
            double chunkX = Math.floor((plot.center().field_1352 + 48.0) / 96.0);
            double chunkZ = Math.floor((plot.center().field_1350 + 48.0) / 96.0);
            float chunkMinX = (float)((double)((float)(chunkX * 96.0 - 48.0)) - cameraX);
            float chunkMinZ = (float)((double)((float)(chunkZ * 96.0 - 48.0)) - cameraZ);
            float y1 = (float)(66.0 - cameraY);
            float y2 = (float)(100.0 - cameraY);
            for (i = 0; i <= 96; i += 96) {
                for (int j = 0; j <= 96; j += 96) {
                    float x = chunkMinX + (float)i;
                    float z = chunkMinZ + (float)j;
                    buffer.method_56824(entry, x, y1, z).method_22915(1.0f, 0.0f, 0.0f, 0.0f).method_60831(entry, x, y1, z);
                    buffer.method_56824(entry, x, y1, z).method_22915(1.0f, 0.0f, 0.0f, 0.5f).method_60831(entry, x, y1, z);
                    buffer.method_56824(entry, x, y2, z).method_22915(1.0f, 0.0f, 0.0f, 0.5f).method_60831(entry, x, y2, z);
                    buffer.method_56824(entry, x, y2, z).method_22915(1.0f, 0.0f, 0.0f, 0.0f).method_60831(entry, x, y2, z);
                }
            }
            for (i = 66; i <= 101; i += 2) {
                float y = (float)((double)i - cameraY);
                int color = i % 8 == 0 ? GREEN : YELLOW;
                buffer.method_56824(entry, chunkMinX, y, chunkMinZ).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_60831(entry, chunkMinX, y, chunkMinZ);
                buffer.method_56824(entry, chunkMinX, y, chunkMinZ).method_39415(color).method_60831(entry, chunkMinX, y, chunkMinZ);
                buffer.method_56824(entry, chunkMinX, y, chunkMinZ + 96.0f).method_39415(color).method_60831(entry, chunkMinX, y, chunkMinZ + 96.0f);
                buffer.method_56824(entry, chunkMinX + 96.0f, y, chunkMinZ + 96.0f).method_39415(color).method_60831(entry, chunkMinX + 96.0f, y, chunkMinZ + 96.0f);
                buffer.method_56824(entry, chunkMinX + 96.0f, y, chunkMinZ).method_39415(color).method_60831(entry, chunkMinX + 96.0f, y, chunkMinZ);
                buffer.method_56824(entry, chunkMinX, y, chunkMinZ).method_39415(color).method_60831(entry, chunkMinX, y, chunkMinZ);
                buffer.method_56824(entry, chunkMinX, y, chunkMinZ).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_60831(entry, chunkMinX, y, chunkMinZ);
            }
        }
        stack.method_22909();
    }

    public record Plot(int id, Cuboid cuboid, class_243 center) {
    }
}

