/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.item;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.data.hypixel.item.Rarity;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ItemRenderEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.render.GuiRenderUtils;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;

public class TooltipDecoratorFeature
extends Feature {
    private static final Map<Rarity, Pair<Integer, Integer>> RARITY_COLORS = Map.ofEntries(Map.entry(Rarity.COMMON, Pair.of((Object)new Color(252, 252, 252).getRGB(), (Object)new Color(134, 134, 134).getRGB())), Map.entry(Rarity.UNCOMMON, Pair.of((Object)new Color(21, 215, 0).getRGB(), (Object)new Color(57, 124, 25).getRGB())), Map.entry(Rarity.RARE, Pair.of((Object)new Color(6, 57, 234).getRGB(), (Object)new Color(15, 40, 128).getRGB())), Map.entry(Rarity.EPIC, Pair.of((Object)new Color(110, 6, 171).getRGB(), (Object)new Color(73, 23, 101).getRGB())), Map.entry(Rarity.LEGENDARY, Pair.of((Object)new Color(236, 156, 5).getRGB(), (Object)new Color(173, 95, 0).getRGB())), Map.entry(Rarity.MYTHIC, Pair.of((Object)new Color(219, 0, 255).getRGB(), (Object)new Color(155, 4, 245).getRGB())), Map.entry(Rarity.SPECIAL, Pair.of((Object)new Color(250, 0, 0).getRGB(), (Object)new Color(161, 0, 0).getRGB())), Map.entry(Rarity.VERY_SPECIAL, Pair.of((Object)new Color(250, 0, 0).getRGB(), (Object)new Color(161, 0, 0).getRGB())), Map.entry(Rarity.DIVINE, Pair.of((Object)new Color(0, 241, 248).getRGB(), (Object)new Color(1, 178, 154).getRGB())), Map.entry(Rarity.ULTIMATE, Pair.of((Object)new Color(115, 0, 0).getRGB(), (Object)new Color(77, 0, 0).getRGB())));

    public TooltipDecoratorFeature() {
        ItemRenderEvents.POST_TOOLTIP.register(this::onRenderTooltip);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().uiAndVisuals.toolTipDecorator.enabled;
    }

    private void onRenderTooltip(class_332 context, class_1799 itemStack, int x, int y, int width, int height, class_327 textRenderer, List<class_5684> components) {
        if (TooltipDecoratorFeature.CLIENT.field_1724 == null || TooltipDecoratorFeature.CLIENT.field_1687 == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (itemStack == null || itemStack.method_7960()) {
            return;
        }
        Rarity rarity = ItemUtils.getItemRarity(itemStack);
        if (rarity != null) {
            if (!RARITY_COLORS.containsKey((Object)rarity)) {
                return;
            }
            Pair<Integer, Integer> colors = RARITY_COLORS.get((Object)rarity);
            if (colors != null) {
                this.drawBorder(context, x, y, width, height, colors);
            }
        }
    }

    private void drawBorder(class_332 context, int x, int y, int width, int height, Pair<Integer, Integer> colors) {
        context.method_51448().pushMatrix();
        GuiRenderUtils.drawGradientRect(context, 400, x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, (Integer)colors.left(), (Integer)colors.right());
        GuiRenderUtils.drawGradientRect(context, 400, x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, (Integer)colors.left(), (Integer)colors.right());
        GuiRenderUtils.drawGradientRect(context, 400, x - 3, y - 3, x + width + 3, y - 3 + 1, (Integer)colors.left(), (Integer)colors.left());
        GuiRenderUtils.drawGradientRect(context, 400, x - 3, y + height + 2, x + width + 3, y + height + 3, (Integer)colors.right(), (Integer)colors.right());
        context.method_51448().popMatrix();
    }
}

