/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.stonks.graph;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.data.generic.ItemPrice;
import fr.siroz.cariboustonks.feature.stonks.AbstractItemStonksWidget;
import fr.siroz.cariboustonks.feature.stonks.graph.GraphDataFilter;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.TimeUtils;
import fr.siroz.cariboustonks.util.colors.ColorUtils;
import fr.siroz.cariboustonks.util.render.GuiRenderUtils;
import fr.siroz.cariboustonks.util.render.gui.Point;
import java.awt.Color;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemGraphWidget
extends AbstractItemStonksWidget {
    private GraphDataFilter.Granularity granularity;
    private Type type = Type.AUCTION;
    private Instant lastUpdateTime;
    private final List<ItemPrice> rawData = new ArrayList<ItemPrice>();
    private Map<Point, ItemPrice> graphData;
    private List<ItemPrice> prices;
    private Instant minTime;
    private Instant maxTime;
    private double minPrice;
    private double maxPrice;

    public ItemGraphWidget(@NotNull List<ItemPrice> neuData, int width, int height) {
        super(width, height);
        this.granularity = GraphDataFilter.Granularity.DAY;
        this.lastUpdateTime = Instant.now();
        this.rawData.addAll(neuData);
        this.rawData.sort(Comparator.comparing(ItemPrice::time));
        this.prices = GraphDataFilter.filterData(this.rawData, this.granularity);
        this.type = this.prices.stream().filter(itemPrice -> itemPrice.sellPrice() != null).findFirst().map(itemPrice -> Type.BAZAAR).orElse(this.type);
        this.updateMinMaxValues();
    }

    public boolean updateGranularity() {
        Instant now = Instant.now();
        if (Duration.between(this.lastUpdateTime, now).getSeconds() < 2L) {
            return false;
        }
        GraphDataFilter.Granularity[] values = GraphDataFilter.Granularity.values();
        int currentIndex = this.granularity.ordinal();
        int nextIndex = (currentIndex + 1) % values.length;
        this.updateGraphData(values[nextIndex]);
        this.lastUpdateTime = now;
        return true;
    }

    public String getGranularity() {
        return switch (this.granularity) {
            default -> throw new MatchException(null, null);
            case GraphDataFilter.Granularity.HOUR -> "Hour";
            case GraphDataFilter.Granularity.DAY -> "Day";
            case GraphDataFilter.Granularity.WEEK -> "Week";
            case GraphDataFilter.Granularity.MONTH -> "Month";
        };
    }

    private void updateGraphData(GraphDataFilter.Granularity newGranularity) {
        this.prices = null;
        this.prices = GraphDataFilter.filterData(this.rawData, newGranularity);
        this.updateMinMaxValues();
        this.granularity = newGranularity;
    }

    private void updateMinMaxValues() {
        this.minTime = this.prices.stream().map(ItemPrice::time).min(Instant::compareTo).orElse(Instant.now());
        this.maxTime = this.prices.stream().map(ItemPrice::time).max(Instant::compareTo).orElse(Instant.now());
        if (this.type == Type.BAZAAR) {
            this.minPrice = Math.min(this.prices.stream().mapToDouble(ItemPrice::buyPrice).min().orElse(0.0), this.prices.stream().mapToDouble(ItemPrice::sellPrice).min().orElse(0.0));
            this.maxPrice = Math.max(this.prices.stream().mapToDouble(ItemPrice::buyPrice).max().orElse(1.0), this.prices.stream().mapToDouble(ItemPrice::sellPrice).min().orElse(1.0));
        } else {
            this.minPrice = this.prices.stream().mapToDouble(ItemPrice::buyPrice).min().orElse(0.0);
            this.maxPrice = this.prices.stream().mapToDouble(ItemPrice::buyPrice).max().orElse(1.0);
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, int x, int y) {
        int x1 = x + 20;
        int y1 = y + 25;
        int x2 = x1 + this.width / 2;
        int y2 = y1 + this.height / 2;
        int borderMarge = 10;
        int borderColor = new Color(192, 192, 192).getRGB();
        context.method_25294(x1, y1 - 10, x2, y1 - 10 + 1, borderColor);
        context.method_25294(x1, y2 + 10 - 1, x2, y2 + 10, borderColor);
        context.method_25294(x1, y1 - 10 + 1, x1 + 1, y2 + 10 - 1, borderColor);
        context.method_25294(x2 - 1, y1 - 10 + 1, x2, y2 + 10 - 1, borderColor);
        if (this.prices == null || this.prices.isEmpty() || this.prices.size() < 3) {
            return;
        }
        if (this.minTime.equals(this.maxTime) || this.minPrice == this.maxPrice) {
            return;
        }
        ArrayList<Point> pointsBuy = new ArrayList<Point>();
        HashMap<Point, ItemPrice> toData = new HashMap<Point, ItemPrice>();
        for (ItemPrice item : this.prices) {
            double timeRatio = (double)ChronoUnit.MILLIS.between(this.minTime, item.time()) / (double)ChronoUnit.MILLIS.between(this.minTime, this.maxTime);
            double priceRatio = (item.buyPrice() - this.minPrice) / (this.maxPrice - this.minPrice);
            double pointX = (double)x1 + timeRatio * (double)(x2 - x1);
            double pointY = (double)y2 - priceRatio * (double)(y2 - y1);
            pointsBuy.add(new Point((int)Math.round(pointX), (int)Math.round(pointY)));
            toData.put(new Point((int)Math.round(pointX), (int)Math.round(pointY)), item);
        }
        this.graphData = toData;
        if (ConfigManager.getConfig().general.stonks.showGradientInGraphScreen) {
            int startColor = 1926423;
            int endColor = 1926423;
            this.drawGradient(context, pointsBuy, startColor, endColor, y2 + 10, false);
        }
        GuiRenderUtils.renderLinesFromPoints(context, pointsBuy.toArray(new Point[0]), new Color(0, 222, 5), 1);
        if (this.type == Type.BAZAAR) {
            ArrayList<Point> pointsSell = new ArrayList<Point>();
            for (ItemPrice item : this.prices) {
                double timeRatio = (double)ChronoUnit.MILLIS.between(this.minTime, item.time()) / (double)ChronoUnit.MILLIS.between(this.minTime, this.maxTime);
                double priceRatio = (item.sellPrice() - this.minPrice) / (this.maxPrice - this.minPrice);
                double pointX = (double)x1 + timeRatio * (double)(x2 - x1);
                double pointY = (double)y2 - priceRatio * (double)(y2 - y1);
                pointsSell.add(new Point((int)Math.round(pointX), (int)Math.round(pointY)));
            }
            if (ConfigManager.getConfig().general.stonks.showGradientInGraphScreen) {
                int startColor = 0x888313;
                int endColor = 0x888313;
                this.drawGradient(context, pointsSell, startColor, endColor, y2, true);
            }
            GuiRenderUtils.renderLinesFromPoints(context, pointsSell.toArray(new Point[0]), new Color(234, 214, 7), 1);
        }
        this.drawLabels(context, x1, y1, x2, y2);
        this.drawHoveredItem(context, mouseX, mouseY);
    }

    private void drawLabels(class_332 context, int x1, int y1, int x2, int y2) {
        int timeSteps = this.getGranularityStep();
        for (int i = 0; i <= timeSteps; ++i) {
            Instant currentTime = this.minTime.plus((long)i * ChronoUnit.MILLIS.between(this.minTime, this.maxTime) / (long)timeSteps, ChronoUnit.MILLIS);
            int labelX = (int)((double)x1 + (double)(i * (x2 - x1)) / (double)timeSteps);
            String timeLabel = this.formatTimeLabel(currentTime);
            context.method_27535(this.textRenderer, (class_2561)class_2561.method_43470((String)timeLabel), labelX - 12, y2 + 20, Color.WHITE.getRGB());
        }
        int priceSteps = 5;
        for (int i = 0; i <= priceSteps; ++i) {
            double currentPrice = this.minPrice + (double)i * (this.maxPrice - this.minPrice) / (double)priceSteps;
            int labelY = (int)((double)y2 - (double)(i * (y2 - y1)) / (double)priceSteps);
            String priceLabel = StonksUtils.SHORT_FLOAT_NUMBERS.format(currentPrice);
            context.method_27535(this.textRenderer, (class_2561)class_2561.method_43470((String)priceLabel).method_27692(class_124.field_1065), x2 + 10, labelY, Color.WHITE.getRGB());
        }
    }

    private void drawHoveredItem(class_332 context, int mouseX, int mouseY) {
        if (this.graphData == null || this.graphData.isEmpty() || this.graphData.size() < 3) {
            return;
        }
        int x1 = 20;
        int y1 = 52;
        int x2 = x1 + this.width / 2;
        int y2 = y1 + this.height / 2 + 31;
        if (mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2) {
            Point closestPoint = null;
            double minDistance = Double.MAX_VALUE;
            for (Point point : this.graphData.keySet()) {
                double distance = Math.abs(point.x() - mouseX);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                closestPoint = point;
            }
            if (closestPoint != null) {
                class_5250 priceText;
                ItemPrice item = this.graphData.get(closestPoint);
                class_5250 dateText = class_2561.method_43470((String)TimeUtils.formatInstant(item.time(), TimeUtils.DATE_TIME_FULL)).method_27692(class_124.field_1075);
                class_5250 secondPriceText = null;
                if (this.type == Type.BAZAAR) {
                    priceText = class_2561.method_43470((String)"Bazaar Buy: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(item.buyPrice())).method_27692(class_124.field_1065));
                    secondPriceText = class_2561.method_43470((String)"Bazaar Sell: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(item.sellPrice())).method_27692(class_124.field_1065));
                } else {
                    priceText = class_2561.method_43470((String)"Price: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(item.buyPrice())).method_27692(class_124.field_1065));
                }
                int textWidth = this.textRenderer.method_27525((class_5348)dateText) + 10;
                int height = this.type == Type.BAZAAR && secondPriceText != null ? 34 : 24;
                context.method_49601(mouseX + 7, mouseY - 13, textWidth, height, Color.WHITE.getRGB());
                context.method_27535(this.textRenderer, (class_2561)dateText, mouseX + 10, mouseY - 10, Color.WHITE.getRGB());
                context.method_27535(this.textRenderer, (class_2561)priceText, mouseX + 10, mouseY, Color.WHITE.getRGB());
                if (this.type == Type.BAZAAR && secondPriceText != null) {
                    context.method_27535(this.textRenderer, (class_2561)secondPriceText, mouseX + 10, mouseY + 10, Color.WHITE.getRGB());
                }
                context.method_51742(mouseX, y1 - 5, y2 - 22 + 5, new Color(204, 2, 2).getRGB());
            }
        }
    }

    private int getGranularityStep() {
        return switch (this.granularity) {
            default -> throw new MatchException(null, null);
            case GraphDataFilter.Granularity.HOUR -> 7;
            case GraphDataFilter.Granularity.DAY -> 5;
            case GraphDataFilter.Granularity.WEEK -> 7;
            case GraphDataFilter.Granularity.MONTH -> 5;
        };
    }

    @NotNull
    private String formatTimeLabel(Instant time) {
        ZoneId zoneId = ZoneId.systemDefault();
        return switch (this.granularity) {
            default -> throw new MatchException(null, null);
            case GraphDataFilter.Granularity.HOUR -> time.atZone(zoneId).format(DateTimeFormatter.ofPattern("HH:mm"));
            case GraphDataFilter.Granularity.DAY -> time.atZone(zoneId).format(DateTimeFormatter.ofPattern("HH:mm"));
            case GraphDataFilter.Granularity.WEEK -> time.atZone(zoneId).format(DateTimeFormatter.ofPattern("EEE"));
            case GraphDataFilter.Granularity.MONTH -> time.atZone(zoneId).format(DateTimeFormatter.ofPattern("EEE dd"));
        };
    }

    private void drawGradient(class_332 context, List<Point> pointsToRender, int startColor, int endColor, int y2, boolean withSellerPrice) {
        List<Point> gradientPoints = new ArrayList<Point>(pointsToRender);
        if (this.granularity == GraphDataFilter.Granularity.DAY) {
            gradientPoints = StonksUtils.reduceListToApproxSize(gradientPoints, 300);
        }
        this.renderGradient(context, gradientPoints, startColor, endColor, y2 + 10, withSellerPrice);
    }

    private void renderGradient(class_332 context, @NotNull List<Point> pointsToRender, int colorStart, int colorEnd, int y2, boolean withSellerPrice) {
        int minY = pointsToRender.stream().mapToInt(Point::y).min().orElse(0);
        int maxY = pointsToRender.stream().mapToInt(Point::y).max().orElse(0);
        HashSet<Integer> seen = new HashSet<Integer>();
        List<Point> generatedPoints = this.completePoints(pointsToRender);
        for (Point point : generatedPoints) {
            if (seen.contains(point.x())) continue;
            seen.add(point.x());
            if (point.y() < minY) continue;
            float factor = (float)(point.y() - minY) / (float)(maxY - minY);
            Color color = ColorUtils.interpolatedColor(new Color(colorStart), new Color(colorEnd), factor);
            int startX = point.x();
            int startY = point.y();
            int endX = point.x() + 1;
            int endY = y2;
            if (withSellerPrice) {
                startY = point.y() - 1;
            }
            context.method_25296(startX, startY, endX, endY, color.getRGB(), colorEnd);
        }
    }

    @Contract(value="_ -> param1")
    @NotNull
    private List<Point> completePoints(@NotNull List<Point> pointsToComplete) {
        ArrayList<Integer> missingX = new ArrayList<Integer>();
        int startX = pointsToComplete.getFirst().x();
        int endX = pointsToComplete.getLast().x();
        for (int x = startX; x <= endX; ++x) {
            if (this.getYForX(pointsToComplete, x) != null) continue;
            missingX.add(x);
        }
        ArrayList<Point> newPoints = new ArrayList<Point>();
        Iterator iterator = missingX.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)iterator.next();
            int interpolatedY = this.interpolateY(pointsToComplete, x);
            newPoints.add(new Point(x, interpolatedY));
        }
        pointsToComplete.addAll(newPoints);
        pointsToComplete.sort(Comparator.comparingInt(Point::x));
        return pointsToComplete;
    }

    private int interpolateY(@NotNull List<Point> points, int x) {
        Point before = null;
        Point after = null;
        for (Point point : points) {
            if (point.x() < x) {
                before = point;
                continue;
            }
            if (point.x() <= x) continue;
            after = point;
            break;
        }
        if (before == null || after == null) {
            return 0;
        }
        float slope = (float)(after.y() - before.y()) / (float)(after.x() - before.x());
        return (int)((float)before.y() + slope * (float)(x - before.x()));
    }

    @Nullable
    private Integer getYForX(@NotNull List<Point> points, int x) {
        for (Point point : points) {
            if (point.x() != x) continue;
            return point.y();
        }
        return null;
    }

    static enum Type {
        AUCTION,
        BAZAAR;

    }
}

