/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.vanilla;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.feature.Feature;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class MuteVanillaSoundFeature
extends Feature {
    private static final Map<class_2960, BooleanSupplier> EXACT_SOUND_RULES = Map.of(class_3417.field_14956.comp_3319(), () -> ConfigManager.getConfig().vanilla.sound.muteLightning, class_3417.field_14865.comp_3319(), () -> ConfigManager.getConfig().vanilla.sound.muteLightning, class_3417.field_14778.comp_3319(), () -> ConfigManager.getConfig().vanilla.sound.mutePlayerFall, class_3417.field_14794.comp_3319(), () -> ConfigManager.getConfig().vanilla.sound.mutePlayerFall, class_3417.field_14713.comp_3319(), () -> ConfigManager.getConfig().vanilla.sound.muteEnderman, class_3417.field_14967.comp_3319(), () -> ConfigManager.getConfig().vanilla.sound.muteEnderman);
    private static final List<PrefixRule> PREFIX_SOUND_RULES = List.of(new PrefixRule("entity.phantom", () -> ConfigManager.getConfig().vanilla.sound.mutePhantom));

    public MuteVanillaSoundFeature() {
        WorldEvents.ALLOW_SOUND.register(this::allowSound);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock();
    }

    private boolean allowSound(class_3414 soundEvent) {
        if (!this.isEnabled()) {
            return true;
        }
        class_2960 id = soundEvent.comp_3319();
        BooleanSupplier exact = EXACT_SOUND_RULES.get(id);
        if (exact != null && exact.getAsBoolean()) {
            return false;
        }
        String path = id.method_12832();
        for (PrefixRule pr : PREFIX_SOUND_RULES) {
            if (!path.startsWith(pr.prefix()) || !pr.enabled().getAsBoolean()) continue;
            return false;
        }
        return true;
    }

    private record PrefixRule(String prefix, BooleanSupplier enabled) {
    }
}

