/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.container.overlay;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.crash.CrashType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.Manager;
import fr.siroz.cariboustonks.manager.container.ContainerMatcherTrait;
import fr.siroz.cariboustonks.manager.container.overlay.ContainerOverlay;
import fr.siroz.cariboustonks.mixin.accessors.HandledScreenAccessor;
import fr.siroz.cariboustonks.util.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_476;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ContainerOverlayManager
implements Manager {
    private static final class_310 CLIENT = class_310.method_1551();
    private final Map<Feature, ContainerOverlay> containerOverlayMap = new HashMap<Feature, ContainerOverlay>();
    private ContainerOverlay currentContainerOverlay = null;
    private List<ColorHighlight> highlights;

    @ApiStatus.Internal
    public ContainerOverlayManager() {
        ScreenEvents.BEFORE_INIT.register(this::onScreenBeforeInit);
    }

    @Override
    public void register(@NotNull Feature feature) {
        if (feature instanceof ContainerOverlay) {
            ContainerOverlay containerOverlay = (ContainerOverlay)((Object)feature);
            this.containerOverlayMap.put(feature, containerOverlay);
        }
    }

    private void onScreenBeforeInit(class_310 _client, class_437 screen, int _scaledWidth, int _scaledHeight) {
        if (SkyBlockAPI.isOnSkyBlock() && screen instanceof class_476) {
            class_476 genericContainerScreen = (class_476)screen;
            ScreenEvents.remove((class_437)screen).register(_screen -> this.clearScreen());
            this.onScreen(genericContainerScreen);
        } else {
            this.clearScreen();
        }
    }

    public void markHighlightsDirty() {
        this.highlights = null;
    }

    public void draw(class_332 context, class_465<class_1707> handledScreen, List<class_1735> slots) {
        if (this.currentContainerOverlay == null) {
            return;
        }
        int screenWidth = CLIENT.method_22683().method_4486();
        int screenHeight = CLIENT.method_22683().method_4502();
        try {
            this.currentContainerOverlay.render(context, screenWidth, screenHeight, 0, 0);
        }
        catch (Throwable throwable) {
            CaribouStonks.core().reportCrash(CrashType.CONTAINER, this.currentContainerOverlay.getClass().getSimpleName(), this.currentContainerOverlay.getClass().getName(), "render", throwable);
        }
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)((HandledScreenAccessor)handledScreen).getX(), (float)((HandledScreenAccessor)handledScreen).getY());
        if (this.highlights == null) {
            this.highlights = this.currentContainerOverlay.content(this.slotMap(slots.subList(0, ((class_1707)handledScreen.method_17577()).method_17388() * 9)));
        }
        for (ColorHighlight highlight : this.highlights) {
            class_1735 slot = slots.get(highlight.slot());
            context.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, highlight.color().asInt());
        }
        context.method_51448().popMatrix();
    }

    private void onScreen(@NotNull class_476 screen) {
        for (Map.Entry<Feature, ContainerOverlay> overlay : this.containerOverlayMap.entrySet()) {
            ContainerMatcherTrait trait;
            Feature feature;
            if (!overlay.getKey().isEnabled() || !((feature = overlay.getKey()) instanceof ContainerMatcherTrait) || !(trait = (ContainerMatcherTrait)((Object)feature)).matches((class_437)screen)) continue;
            this.currentContainerOverlay = overlay.getValue();
            this.markHighlightsDirty();
            return;
        }
        this.clearScreen();
    }

    private void clearScreen() {
        if (this.currentContainerOverlay != null) {
            this.currentContainerOverlay.reset();
            this.currentContainerOverlay = null;
        }
    }

    @NotNull
    private Int2ObjectMap<class_1799> slotMap(@NotNull List<class_1735> slots) {
        Int2ObjectRBTreeMap slotMap = new Int2ObjectRBTreeMap();
        for (int i = 0; i < slots.size(); ++i) {
            slotMap.put(i, (Object)slots.get(i).method_7677());
        }
        return slotMap;
    }
}

