/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.hud;

import fr.siroz.cariboustonks.manager.hud.Hud;
import fr.siroz.cariboustonks.manager.hud.HudConfig;
import fr.siroz.cariboustonks.manager.hud.element.HudElement;
import fr.siroz.cariboustonks.manager.hud.element.HudIconLine;
import fr.siroz.cariboustonks.manager.hud.element.HudTableRow;
import fr.siroz.cariboustonks.manager.hud.element.HudTextLine;
import fr.siroz.cariboustonks.util.colors.Colors;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;

public final class MultiElementHud
extends Hud {
    private static final int SPACING = 2;
    private final List<HudTextLine> defaultText;
    private final Supplier<List<? extends HudElement>> elementSupplier;

    public MultiElementHud(@NotNull Supplier<Boolean> enabledSupplier, @NotNull List<HudTextLine> defaultText, @NotNull Supplier<List<? extends HudElement>> elementSupplier, @NotNull HudConfig hudConfig, int defaultX, int defaultY) {
        super(enabledSupplier, hudConfig, defaultX, defaultY);
        if (defaultText.isEmpty()) {
            throw new IllegalArgumentException("The text list cannot be empty");
        }
        this.defaultText = defaultText;
        this.elementSupplier = elementSupplier;
    }

    @Override
    public int width() {
        int maxWidth = this.defaultText.stream().mapToInt(line -> MultiElementHud.CLIENT.field_1772.method_27525((class_5348)line.text())).max().orElse(0);
        return (int)((float)maxWidth * this.scale());
    }

    @Override
    public int height() {
        Objects.requireNonNull(MultiElementHud.CLIENT.field_1772);
        int lineHeight = (int)(9.0f * this.scale());
        return this.defaultText.stream().mapToInt(t -> lineHeight + (t.spaceAfter() ? 2 : 0)).sum() - 2;
    }

    @Override
    public void renderScreen(class_332 context) {
        this.render(this.defaultText, context, this.x(), this.y(), this.scale());
    }

    @Override
    public void renderHud(class_332 context, class_9779 tickCounter) {
        if (this.shouldRender()) {
            this.render(this.elementSupplier.get(), context, this.hudConfig.x(), this.hudConfig.y(), this.hudConfig.scale());
        }
    }

    private void render(@NotNull List<? extends HudElement> elements, @NotNull class_332 context, int x, int y, float scale) {
        context.method_51448().pushMatrix();
        context.method_51448().scale(scale, scale);
        int maxCols = elements.stream().filter(e -> e instanceof HudTableRow).mapToInt(r -> r.getCells().length).max().orElse(0);
        int[] colWidth = new int[maxCols];
        for (HudElement hudElement : elements) {
            if (!(hudElement instanceof HudTableRow)) continue;
            HudTableRow row = (HudTableRow)hudElement;
            class_2561[] cells = row.getCells();
            for (int i = 0; i < cells.length; ++i) {
                int n = MultiElementHud.CLIENT.field_1772.method_27525((class_5348)cells[i]);
                if (n <= colWidth[i]) continue;
                colWidth[i] = n;
            }
        }
        int baseY = (int)((float)y / scale);
        boolean bl = false;
        int cellPadding = (int)(2.0f * scale);
        Objects.requireNonNull(MultiElementHud.CLIENT.field_1772);
        int lineHeight = 9;
        for (HudElement hudElement : elements) {
            if (hudElement instanceof HudTableRow) {
                HudTableRow row = (HudTableRow)hudElement;
                int cellX = (int)((float)x / scale);
                class_2561[] cells = row.getCells();
                for (int i = 0; i < cells.length; ++i) {
                    context.method_51439(MultiElementHud.CLIENT.field_1772, cells[i], cellX, baseY + var9_12, Colors.WHITE.asInt(), false);
                    cellX += colWidth[i] + cellPadding;
                }
            } else if (hudElement instanceof HudTextLine) {
                HudTextLine line = (HudTextLine)hudElement;
                context.method_51439(MultiElementHud.CLIENT.field_1772, line.text(), (int)((float)x / scale), baseY + var9_12, Colors.WHITE.asInt(), false);
            } else if (hudElement instanceof HudIconLine) {
                HudIconLine icon = (HudIconLine)hudElement;
                context.method_51427(icon.stack(), (int)((float)x / scale), baseY + var9_12);
                context.method_51439(MultiElementHud.CLIENT.field_1772, icon.text(), (int)((float)x / scale) + 18, baseY + var9_12 + 4, Colors.WHITE.asInt(), false);
            }
            var9_12 += hudElement instanceof HudIconLine ? 16 : lineHeight;
            if (!hudElement.hasSpaceAfter()) continue;
            var9_12 += (int)(2.0f * scale);
        }
        context.method_51448().popMatrix();
    }
}

