/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.hud.builder;

import fr.siroz.cariboustonks.manager.hud.element.HudElement;
import fr.siroz.cariboustonks.manager.hud.element.HudIconLine;
import fr.siroz.cariboustonks.manager.hud.element.HudTableRow;
import fr.siroz.cariboustonks.manager.hud.element.HudTextLine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public final class HudElementBuilder {
    private final List<HudElement> elements = new ArrayList<HudElement>();

    public HudElementBuilder clear() {
        this.elements.clear();
        return this;
    }

    public HudElementBuilder appendTitle(@NotNull class_2561 text) {
        this.elements.addFirst(new HudTextLine(text, true));
        return this;
    }

    public HudElementBuilder appendLine(@NotNull class_2561 text) {
        this.elements.add(new HudTextLine(text, false));
        return this;
    }

    public HudElementBuilder appendTableRow(@NotNull class_2561 c1, @NotNull class_2561 c2, @NotNull class_2561 c3) {
        this.elements.add(new HudTableRow(c1, c2, c3, false));
        return this;
    }

    public HudElementBuilder appendIconLine(@NotNull class_1799 stack, @NotNull class_2561 text) {
        this.elements.add(new HudIconLine(stack, text, false));
        return this;
    }

    public HudElementBuilder appendSpace() {
        if (!this.elements.isEmpty()) {
            HudElement last = this.elements.removeLast();
            if (last instanceof HudTextLine) {
                HudTextLine textLine = (HudTextLine)last;
                this.elements.add(new HudTextLine(textLine.text(), true));
            } else if (last instanceof HudTableRow) {
                HudTableRow row = (HudTableRow)last;
                this.elements.add(new HudTableRow(row.getCells(), true));
            } else if (last instanceof HudIconLine) {
                HudIconLine iconLine = (HudIconLine)last;
                this.elements.add(new HudIconLine(iconLine.stack(), iconLine.text(), true));
            }
        }
        return this;
    }

    public List<HudElement> build() {
        return this.elements;
    }
}

