/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.slayer;

import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ChatEvents;
import fr.siroz.cariboustonks.event.HudEvents;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.event.SkyBlockEvents;
import fr.siroz.cariboustonks.manager.Manager;
import fr.siroz.cariboustonks.manager.slayer.SlayerBossFight;
import fr.siroz.cariboustonks.manager.slayer.SlayerQuest;
import fr.siroz.cariboustonks.manager.slayer.SlayerTier;
import fr.siroz.cariboustonks.manager.slayer.SlayerType;
import fr.siroz.cariboustonks.util.ScoreboardUtils;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SlayerManager
implements Manager {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern SLAYER_PATTERN = Pattern.compile("Revenant Horror|Atoned Horror|Tarantula Broodfather|Sven Packmaster|Voidgloom Seraph|Inferno Demonlord|Bloodfiend");
    private static final Pattern SLAYER_TIER_PATTERN = Pattern.compile("^(Revenant Horror|Tarantula Broodfather|Sven Packmaster|Voidgloom Seraph|Inferno Demonlord|Riftstalker Bloodfiend)\\s+(I|II|III|IV|V)$");
    private static final String QUEST_CANCELLED = "Your Slayer Quest has been cancelled!";
    private static final String QUEST_FAILED = "SLAYER QUEST FAILED!";
    private static final String QUEST_STARTED = "SLAYER QUEST STARTED!";
    private static final String BOSS_SLAIN = "NICE! SLAYER BOSS SLAIN!";
    private static final String QUEST_COMPLETE = "SLAYER QUEST COMPLETE!";
    private static final String SCOREBOARD_BOSS_SPAWNED = "Slay the boss!";
    private SlayerBossFight bossFight;
    private SlayerQuest quest;

    public SlayerManager() {
        ChatEvents.MESSAGE_RECEIVED.register(this::onMessage);
        SkyBlockEvents.ISLAND_CHANGE.register(this::onIslandChange);
        HudEvents.SCOREBOARD_UPDATE.register(this::onScoreboardUpdate);
        NetworkEvents.ARMORSTAND_UPDATE_PACKET.register(this::onArmorStandUpdate);
    }

    public boolean isInQuest() {
        return this.quest != null;
    }

    public boolean isBossSpawned() {
        return this.isInQuest() && this.bossFight != null;
    }

    public boolean isSlayerTier(@NotNull SlayerTier tier) {
        return this.quest != null && this.quest.getSlayerTier() == tier;
    }

    public boolean isInQuestWithBoss(SlayerType slayerType) {
        return this.isBossSpawned() && this.quest != null && this.quest.getSlayerType().equals((Object)slayerType);
    }

    public boolean isInQuestTypeWithoutBoss(@NotNull SlayerType slayerType) {
        return !this.isBossSpawned() && this.quest != null && this.quest.getSlayerType().equals((Object)slayerType);
    }

    @NotNull
    public List<class_1297> getMinibosses() {
        return this.quest != null ? this.quest.getMinibosses() : List.of();
    }

    @Nullable
    public class_1297 getBossEntity() {
        return this.bossFight != null ? this.bossFight.getBossEntity() : null;
    }

    private void onMessage(@NotNull class_2561 text) {
        if (!SkyBlockAPI.isOnSkyBlock()) {
            return;
        }
        String message = text.getString();
        switch (message = message.replaceFirst("^\\s+", "")) {
            case "Your Slayer Quest has been cancelled!": 
            case "SLAYER QUEST FAILED!": {
                if (this.quest != null) {
                    ((SkyBlockEvents.SlayerQuestFail)SkyBlockEvents.SLAYER_QUEST_FAIL.invoker()).onFail(this.quest.getSlayerType(), this.quest.getSlayerTier());
                }
                this.quest = null;
                this.bossFight = null;
                break;
            }
            case "SLAYER QUEST STARTED!": {
                if (this.quest == null) {
                    this.quest = new SlayerQuest(this);
                }
                ((SkyBlockEvents.SlayerQuestStart)SkyBlockEvents.SLAYER_QUEST_START.invoker()).onStart(this.quest.getSlayerType(), this.quest.getSlayerTier(), false);
                this.bossFight = null;
                break;
            }
            case "NICE! SLAYER BOSS SLAIN!": {
                if (this.quest == null || this.bossFight == null) break;
                this.bossFight.setSlain(true);
                ((SkyBlockEvents.SlayerBossDeath)SkyBlockEvents.SLAYER_BOSS_DEATH.invoker()).onDeath(this.quest.getSlayerType(), this.quest.getSlayerTier(), this.bossFight.getBossSpawnTime());
                break;
            }
            case "SLAYER QUEST COMPLETE!": {
                if (this.quest != null && this.bossFight != null && !this.bossFight.isSlain()) {
                    ((SkyBlockEvents.SlayerBossDeath)SkyBlockEvents.SLAYER_BOSS_DEATH.invoker()).onDeath(this.quest.getSlayerType(), this.quest.getSlayerTier(), this.bossFight.getBossSpawnTime());
                }
                this.bossFight = null;
                break;
            }
        }
    }

    private void onIslandChange(@NotNull IslandType islandType) {
        this.bossFight = null;
        this.quest = null;
        TickScheduler.getInstance().runLater(() -> this.updateSlayerBossInfo(false, (List<String>)ScoreboardUtils.getStringScoreboard()), 3, TimeUnit.SECONDS);
    }

    private void onScoreboardUpdate(@NotNull List<String> lines) {
        this.updateSlayerBossInfo(true, lines);
    }

    private void onArmorStandUpdate(@NotNull class_1531 armorStand, boolean equipment) {
        if (!SkyBlockAPI.isOnSkyBlock() || equipment) {
            return;
        }
        if (this.quest == null || !armorStand.method_16914() || this.isBossSpawned() && this.bossFight.getBossEntity() != null) {
            return;
        }
        if (armorStand.method_5477().getString().contains(CLIENT.method_1548().method_1676())) {
            for (class_1297 otherArmorStands : this.getArmorStands((class_1297)armorStand)) {
                Matcher slayerMatcher = SLAYER_PATTERN.matcher(otherArmorStands.method_5477().getString());
                if (!slayerMatcher.find()) continue;
                if (this.bossFight != null && this.bossFight.getBossEntity() == null) {
                    this.bossFight.tryToFindBoss((class_1531)otherArmorStands);
                    return;
                }
                this.bossFight = new SlayerBossFight(this, (class_1531)otherArmorStands);
                return;
            }
        }
        if (!armorStand.method_24516((class_1297)SlayerManager.CLIENT.field_1724, 20.0)) {
            return;
        }
        for (SlayerType type : SlayerType.values()) {
            for (String minibossName : type.getMinibossNames()) {
                if (!armorStand.method_5477().getString().contains(minibossName) || !this.isInQuestTypeWithoutBoss(type)) continue;
                this.quest.onMinibossSpawn(armorStand, type);
            }
        }
    }

    private void updateSlayerBossInfo(boolean onScoreboardUpdate, List<String> scoreboardLines) {
        if (onScoreboardUpdate && this.quest == null) {
            return;
        }
        try {
            for (String line : scoreboardLines) {
                Matcher slayerTierMatcher = SLAYER_TIER_PATTERN.matcher(line);
                if (slayerTierMatcher.find()) {
                    if (this.quest == null || !slayerTierMatcher.group(1).equals(this.quest.getSlayerType().getBossName()) || !slayerTierMatcher.group(2).equals(this.quest.getSlayerTier().name())) {
                        this.quest = new SlayerQuest(this);
                    }
                    SlayerType slayerType = SlayerType.fromBossName(slayerTierMatcher.group(1));
                    SlayerTier slayerTier = SlayerTier.valueOf(slayerTierMatcher.group(2));
                    this.quest.setSlayerType(slayerType);
                    this.quest.setSlayerTier(slayerTier);
                    ((SkyBlockEvents.SlayerQuestStart)SkyBlockEvents.SLAYER_QUEST_START.invoker()).onStart(slayerType, slayerTier, true);
                    continue;
                }
                if (!line.equals(SCOREBOARD_BOSS_SPAWNED) || this.isBossSpawned()) continue;
                this.bossFight = new SlayerBossFight(this, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    SlayerQuest getQuest() {
        return this.quest;
    }

    @Nullable
    <T extends class_1297> T findClosestEntity(@Nullable class_1299<T> entityType, @Nullable class_1531 armorStand) {
        if (entityType == null) {
            return null;
        }
        if (armorStand == null) {
            return null;
        }
        List entities = armorStand.method_37908().method_18023(entityType, armorStand.method_5829().method_1009(0.0, 1.5, 0.0), e -> {
            class_1308 mob;
            return e.method_5805() && (!(e instanceof class_1308) || !(mob = (class_1308)e).method_6109());
        });
        entities.sort(Comparator.comparingDouble(arg_0 -> ((class_1531)armorStand).method_5858(arg_0)));
        return (T)(switch (entities.size()) {
            case 0 -> null;
            case 1 -> (class_1297)entities.getFirst();
            default -> entities.stream().min(Comparator.comparingInt(entity -> Math.abs(entity.field_6012 - armorStand.field_6012))).get();
        });
    }

    private List<class_1297> getArmorStands(@NotNull class_1297 entity) {
        return entity.method_37908().method_8333(entity, entity.method_5829().method_1009(0.1, 1.5, 0.1), e -> e instanceof class_1531 && e.method_16914());
    }
}

