/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.screen;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.config.configs.VanillaConfig;
import fr.siroz.cariboustonks.screen.CaribousStonksScreen;
import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.render.GuiRenderUtils;
import fr.siroz.cariboustonks.util.render.gui.DoubleSliderWidget;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8029;
import net.minecraft.class_8030;
import net.minecraft.class_8132;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HeldItemViewConfigScreen
extends CaribousStonksScreen {
    @Nullable
    private final class_437 parent;
    @Nullable
    private class_8132 layout;
    private final class_1268 hand;
    private final class_1799 previewItem;
    private final VanillaConfig.ItemModelCustomization.CustomHand currentHand;
    private final VanillaConfig.ItemModelCustomization.CustomHand backupHand;
    private boolean changed;

    private HeldItemViewConfigScreen(@Nullable class_437 parent, class_1268 hand) {
        super((class_2561)class_2561.method_43470((String)("Customize Held Item for " + (hand == class_1268.field_5808 ? "Main Hand" : "Off Hand"))));
        this.parent = parent;
        this.hand = hand;
        this.previewItem = new class_1799((class_1935)class_1802.field_22022);
        this.currentHand = switch (this.hand) {
            default -> throw new MatchException(null, null);
            case class_1268.field_5808 -> ConfigManager.getConfig().vanilla.itemModelCustomization.mainHand;
            case class_1268.field_5810 -> ConfigManager.getConfig().vanilla.itemModelCustomization.offHand;
        };
        this.backupHand = new VanillaConfig.ItemModelCustomization.CustomHand().copyFrom(this.currentHand);
        this.changed = false;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static HeldItemViewConfigScreen create(@Nullable class_437 parent, @NotNull class_1268 hand) {
        return new HeldItemViewConfigScreen(parent, hand);
    }

    public class_1799 getPreviewItem() {
        return this.previewItem;
    }

    public class_1268 getHand() {
        return this.hand;
    }

    @Override
    protected void onInit() {
        if (this.field_22787 == null || this.field_22787.field_1687 == null) {
            this.layout = new class_8132((class_437)this);
            this.layout.method_48992((class_8021)new class_7842(this.method_25440(), this.field_22793));
            this.layout.method_48999((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"You must be in a world to use this.").method_54663(Colors.ORANGE.asInt()), this.field_22793));
            this.layout.method_48996((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, b -> this.onClose()).method_46432(210).method_46431());
            this.layout.method_48222();
            this.layout.method_48206(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
            return;
        }
        class_7845 grid = new class_7845();
        grid.method_48637(8);
        class_7845.class_7939 adder = grid.method_47610(3);
        adder.method_47613((class_8021)new class_7842(this.field_22785, this.field_22793), 3);
        adder.method_47613((class_8021)new class_7852(0, 10), 3);
        adder.method_47613((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Positions"), this.field_22793), 3);
        adder.method_47612((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"X"), this.field_22793));
        adder.method_47612((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Y"), this.field_22793));
        adder.method_47612((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Z"), this.field_22793));
        adder.method_47612((class_8021)new DoubleSliderWidget(0, 0, 100, 20, (class_2561)class_2561.method_43470((String)"X Position"), -1.0, 1.0, this.currentHand.x, newValue -> {
            this.currentHand.x = (float)newValue;
            this.changed = !this.currentHand.equals(this.backupHand);
        }));
        adder.method_47612((class_8021)new DoubleSliderWidget(0, 0, 100, 20, (class_2561)class_2561.method_43470((String)"Y Position"), -1.0, 1.0, this.currentHand.y, newValue -> {
            this.currentHand.y = (float)newValue;
            this.changed = !this.currentHand.equals(this.backupHand);
        }));
        adder.method_47612((class_8021)new DoubleSliderWidget(0, 0, 100, 20, (class_2561)class_2561.method_43470((String)"Z Position"), -1.0, 1.0, this.currentHand.z, newValue -> {
            this.currentHand.z = (float)newValue;
            this.changed = !this.currentHand.equals(this.backupHand);
        }));
        adder.method_47613((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Size"), this.field_22793), 3);
        adder.method_47613((class_8021)new DoubleSliderWidget(0, 0, 208, 20, (class_2561)class_2561.method_43470((String)"Size"), 0.1f, 1.0, this.currentHand.scale, newValue -> {
            this.currentHand.scale = (float)newValue;
            this.changed = !this.currentHand.equals(this.backupHand);
        }), 3);
        adder.method_47613((class_8021)new class_7852(0, 20), 3);
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Revert"), b -> this.revert()).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Reverts to the last saved values."))).method_46432(100).method_46431());
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> this.reset()).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Resets to the default values."))).method_46432(100).method_46431());
        adder.method_47613((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> this.saveAndClose()).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Saves and close."))).method_46432(208).method_46431(), 3);
        grid.method_48222();
        class_8030 dimensions = this.getEffectiveDimensions(this.field_22789, this.field_22790);
        class_7843.method_49617((class_8021)grid, (class_8030)dimensions, (float)0.5f, (float)0.35f);
        grid.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    @Override
    public void method_25420(@NotNull class_332 context, int mouseX, int mouseY, float deltaTicks) {
        class_8030 dimensions = this.getEffectiveDimensions(this.field_22789, this.field_22790);
        context.method_44379(dimensions.method_49620(), dimensions.method_49618(), dimensions.method_49621(), dimensions.method_49619());
        GuiRenderUtils.enableBlurScissor(dimensions.method_49620(), dimensions.method_49618(), dimensions.comp_1196(), dimensions.comp_1197());
        this.method_57734(context);
        this.method_57735(context);
        context.method_44380();
        context.method_51742(this.isMainHand() ? dimensions.method_49621() : dimensions.method_49620(), dimensions.method_49618() - 1, dimensions.method_49619(), new Color(0, 0, 0).withAlpha(190).asInt());
        context.method_51742(this.isMainHand() ? dimensions.method_49621() - 1 : dimensions.method_49620() + 1, dimensions.method_49618() - 1, dimensions.method_49619(), new Color(255, 255, 255).withAlpha(50).asInt());
    }

    protected void method_48640() {
        if (this.layout != null) {
            this.layout.method_48222();
        }
    }

    @Override
    public void onClose() {
        if (this.field_22787 != null) {
            if (this.changed) {
                this.field_22787.method_1507((class_437)new class_410(confirmation -> {
                    if (confirmation) {
                        this.revert();
                        this.field_22787.method_1507(this.parent);
                    } else {
                        this.field_22787.method_1507((class_437)this);
                    }
                }, CONFIRM_SCREEN_UNSAVED_CHANGE, CONFIRM_SCREEN_PROMPT, CONFIRM_SCREEN_QUIT_MESSAGE, class_5244.field_24335));
            } else {
                this.field_22787.method_1507(this.parent);
            }
        }
    }

    @Contract(value="_, _ -> new")
    @NotNull
    private class_8030 getEffectiveDimensions(int scaledWindowWidth, int scaledWindowHeight) {
        int x = this.isMainHand() ? 0 : scaledWindowWidth / 2;
        int width = scaledWindowWidth / 2;
        return new class_8030(new class_8029(x, 0), width, scaledWindowHeight);
    }

    private boolean isMainHand() {
        return this.hand == class_1268.field_5808;
    }

    private void saveAndClose() {
        ConfigManager.saveConfig();
        this.changed = false;
        this.onClose();
    }

    private void revert() {
        this.currentHand.copyFrom(this.backupHand);
        this.changed = false;
        this.method_41843();
    }

    private void reset() {
        this.currentHand.copyFrom(new VanillaConfig.ItemModelCustomization.CustomHand());
        this.changed = true;
        this.method_41843();
    }
}

