/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.screen.changelog;

import fr.siroz.cariboustonks.core.changelog.ChangelogEntry;
import fr.siroz.cariboustonks.util.colors.Colors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;

class ChangelogListWidget
extends class_4265<LineEntry> {
    private static final int LINE_HEIGHT = 10;
    private static final int PADDING = 10;
    private static final class_2561 SPACE = class_2561.method_43470((String)" ");
    private static final class_2561 SEPARATOR = class_2561.method_43470((String)"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500").method_27692(class_124.field_1063);

    ChangelogListWidget(class_310 client, @NotNull List<ChangelogEntry> changelogs, int width, int height, int y) {
        super(client, width, height, y, 10);
        for (ChangelogEntry entry : changelogs) {
            List<class_2561> lines = this.formatChangelogToTexts(entry, width - 20);
            for (class_2561 text : lines) {
                this.method_25321((class_350.class_351)new LineEntry(text));
            }
            this.method_25321((class_350.class_351)new LineEntry(SPACE));
            this.method_25321((class_350.class_351)new LineEntry(SEPARATOR));
            this.method_25321((class_350.class_351)new LineEntry(SPACE));
        }
        this.method_25321((class_350.class_351)new LineEntry(SPACE));
    }

    public int method_25342() {
        return 10;
    }

    public int method_25322() {
        return super.method_25322() - 20;
    }

    protected int method_65507() {
        return this.field_22758 - 10;
    }

    @NotNull
    private List<class_2561> formatChangelogToTexts(@NotNull ChangelogEntry entry, int maxWidth) {
        ArrayList<class_2561> out = new ArrayList<class_2561>();
        out.add((class_2561)class_2561.method_43470((String)("\u2728 Version " + entry.version)).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        if (entry.date != null && !entry.date.isBlank()) {
            out.add((class_2561)class_2561.method_43470((String)("(" + entry.date + ")")).method_27692(class_124.field_1080));
        }
        out.add(SPACE);
        if (!entry.feature.isEmpty()) {
            out.add((class_2561)class_2561.method_43470((String)"Features:").method_54663(Colors.GREEN.asInt()).method_27692(class_124.field_1067));
            for (String item : entry.feature) {
                for (String l : this.wrapText(" \u2022 " + item, maxWidth)) {
                    out.add((class_2561)class_2561.method_43470((String)l).method_54663(Colors.GREEN.asInt()));
                }
            }
            out.add(SPACE);
        }
        if (!entry.improvement.isEmpty()) {
            out.add((class_2561)class_2561.method_43470((String)"Improvements:").method_54663(Colors.AQUA.asInt()).method_27692(class_124.field_1067));
            for (String item : entry.improvement) {
                for (String l : this.wrapText(" \u2022 " + item, maxWidth)) {
                    out.add((class_2561)class_2561.method_43470((String)l).method_54663(Colors.AQUA.asInt()));
                }
            }
            out.add(SPACE);
        }
        if (!entry.fixed.isEmpty()) {
            out.add((class_2561)class_2561.method_43470((String)"Fixes:").method_54663(Colors.YELLOW.asInt()).method_27692(class_124.field_1067));
            for (String item : entry.fixed) {
                for (String l : this.wrapText(" \u2022 " + item, maxWidth)) {
                    out.add((class_2561)class_2561.method_43470((String)l).method_54663(Colors.YELLOW.asInt()));
                }
            }
            out.add(SPACE);
        }
        if (!entry.backend.isEmpty()) {
            out.add((class_2561)class_2561.method_43470((String)"Backend:").method_54663(Colors.ORANGE.asInt()).method_27692(class_124.field_1067));
            for (String item : entry.backend) {
                for (String l : this.wrapText(" \u2022 " + item, maxWidth)) {
                    out.add((class_2561)class_2561.method_43470((String)l).method_54663(Colors.ORANGE.asInt()));
                }
            }
            out.add(SPACE);
        }
        while (!out.isEmpty() && ((class_2561)out.getFirst()).getString().isBlank()) {
            out.removeFirst();
        }
        while (!out.isEmpty() && ((class_2561)out.getLast()).getString().isBlank()) {
            out.removeLast();
        }
        return out;
    }

    @NotNull
    private List<String> wrapText(@NotNull String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder current = new StringBuilder();
        for (String w : words) {
            String test;
            String string = test = current.isEmpty() ? w : String.valueOf(current) + " " + w;
            if (this.field_22740.field_1772.method_1727(test) > maxWidth && !current.isEmpty()) {
                lines.add(current.toString());
                current = new StringBuilder("    ");
                current.append(w);
                continue;
            }
            if (!current.isEmpty() && !current.toString().trim().isEmpty()) {
                current.append(" ");
            }
            current.append(w);
        }
        if (!current.isEmpty()) {
            lines.add(current.toString());
        }
        return lines;
    }

    protected class LineEntry
    extends class_4265.class_4266<LineEntry> {
        private final class_2561 text;

        LineEntry(class_2561 text) {
            this.text = text;
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
            int drawX = x + 10;
            Objects.requireNonNull(((ChangelogListWidget)ChangelogListWidget.this).field_22740.field_1772);
            int textHeight = 9;
            int drawY = y + Math.max(0, (entryHeight - textHeight) / 2);
            context.method_27535(((ChangelogListWidget)ChangelogListWidget.this).field_22740.field_1772, this.text, drawX, drawY, Colors.WHITE.asInt());
        }
    }
}

