/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.math.bezier;

import fr.siroz.cariboustonks.util.math.bezier.BezierCurve;
import fr.siroz.cariboustonks.util.math.bezier.BezierFitter;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticlePathPredictor
extends BezierFitter {
    public ParticlePathPredictor(int degree) {
        super(degree);
    }

    @Nullable
    public class_243 solve() {
        BezierCurve curve = this.fit();
        if (curve == null) {
            return null;
        }
        class_243 derivative = curve.getDerivative(0.0);
        double t = 3.0 * this.computePitchWeight(derivative) / derivative.method_1033();
        return curve.getPoint(t);
    }

    double computePitchWeight(@NotNull class_243 derivative) {
        return Math.sqrt(24.0 * Math.sin(this.getPitchFromDerivative(derivative) - Math.PI) + 25.0);
    }

    double getPitchFromDerivative(@NotNull class_243 derivative) {
        double pitchAngle;
        double xzAbscissa = Math.sqrt(Math.pow(derivative.field_1352, 2.0) + Math.pow(derivative.field_1350, 2.0));
        double guessPitch = pitchAngle = -Math.atan2(derivative.field_1351, xzAbscissa);
        double resultPitch = Math.atan2(Math.sin(guessPitch) - 0.75, Math.cos(guessPitch));
        double max = 1.5707963267948966;
        double min = -1.5707963267948966;
        for (int i = 0; i < 100; ++i) {
            if (resultPitch < pitchAngle) {
                min = guessPitch;
            } else {
                max = guessPitch;
            }
            guessPitch = (min + max) / 2.0;
            resultPitch = Math.atan2(Math.sin(guessPitch) - 0.75, Math.cos(guessPitch));
            if (resultPitch != pitchAngle) continue;
            return guessPitch;
        }
        return guessPitch;
    }
}

