/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.render;

import com.mojang.blaze3d.systems.RenderPass;
import fr.siroz.cariboustonks.util.render.CustomRenderPipelines;
import fr.siroz.cariboustonks.util.render.gui.Point;
import fr.siroz.cariboustonks.util.render.gui.Quad;
import fr.siroz.cariboustonks.util.render.gui.state.GradientRectGuiElementRenderState;
import fr.siroz.cariboustonks.util.render.gui.state.QuadGuiElementRenderState;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_11219;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.joml.Vector2f;

public final class GuiRenderUtils {
    private static final List<Quad> BATCH_QUADS = new ArrayList<Quad>();
    private static final class_11219 BLUR_SCISSOR_STATE = new class_11219();

    private GuiRenderUtils() {
    }

    public static boolean pointIsInArea(double x, double y, double x1, double y1, double x2, double y2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public static void drawGradientRect(@NotNull class_332 context, int depth, int left, int top, int right, int bottom, int startColor, int endColor) {
        GradientRectGuiElementRenderState renderState = new GradientRectGuiElementRenderState(CustomRenderPipelines.GUI_QUADS, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)context.method_51448()), depth, left, top, right, bottom, startColor, endColor, context.field_44659.method_70863());
        context.field_59826.method_70919((class_11244)renderState);
    }

    public static void renderLinesFromPoints(@NotNull class_332 context, @NotNull @NotNull Point @NotNull [] points, @NotNull Color color, int thickness) {
        if (points.length < 2) {
            return;
        }
        Matrix3x2fStack matrix = context.method_51448();
        for (int i = 0; i < points.length; ++i) {
            Point currentPoint = points[i];
            Point nextPoint = points[i + 1 == points.length ? i - 1 : i + 1];
            int startX = currentPoint.x();
            int startY = currentPoint.y();
            int endX = nextPoint.x();
            int endY = nextPoint.y();
            Vector2f side = new Vector2f((float)endX, (float)endY).sub((float)startX, (float)startY).normalize().perpendicular().mul((float)thickness / 2.0f);
            float x1 = (float)startX + side.x();
            float y1 = (float)startY + side.y();
            float x2 = (float)startX - side.x();
            float y2 = (float)startY - side.y();
            float x3 = (float)endX - side.x();
            float y3 = (float)endY - side.y();
            float x4 = (float)endX + side.x();
            float y4 = (float)endY + side.y();
            Vector2f v1 = matrix.transformPosition(new Vector2f(x1, y1));
            Vector2f v2 = matrix.transformPosition(new Vector2f(x2, y2));
            Vector2f v3 = matrix.transformPosition(new Vector2f(x3, y3));
            Vector2f v4 = matrix.transformPosition(new Vector2f(x4, y4));
            BATCH_QUADS.add(new Quad(v1.x(), v1.y(), v2.x(), v2.y(), v3.x(), v3.y(), v4.x(), v4.y()));
        }
        List<Quad> batchCopy = List.copyOf(BATCH_QUADS);
        BATCH_QUADS.clear();
        QuadGuiElementRenderState renderState = new QuadGuiElementRenderState(class_10799.field_56879, class_11231.method_70899(), batchCopy, color.getRGB(), context.field_44659.method_70863());
        context.field_59826.method_70919((class_11244)renderState);
    }

    public static void enableBlurScissor(int x, int y, int width, int height) {
        BLUR_SCISSOR_STATE.method_70814(x, y, width, height);
    }

    @ApiStatus.Internal
    public static void disableBlurScissor() {
        BLUR_SCISSOR_STATE.method_70813();
    }

    @ApiStatus.Internal
    public static void applyBlurScissorToRenderPass(RenderPass renderPass) {
        if (BLUR_SCISSOR_STATE.method_72091()) {
            class_1041 window = class_310.method_1551().method_22683();
            int framebufferHeight = window.method_4506();
            double scaleFactor = window.method_4495();
            double x = (double)BLUR_SCISSOR_STATE.method_72092() * scaleFactor;
            double y = (double)framebufferHeight - (double)(BLUR_SCISSOR_STATE.method_72093() + BLUR_SCISSOR_STATE.method_72095()) * scaleFactor;
            double width = (double)BLUR_SCISSOR_STATE.method_72094() * scaleFactor;
            double height = (double)BLUR_SCISSOR_STATE.method_72095() * scaleFactor;
            renderPass.enableScissor((int)x, (int)y, Math.max(0, (int)width), Math.max(0, (int)height));
        }
    }
}

