/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.render.gui;

import fr.siroz.cariboustonks.util.colors.Colors;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_9017;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class DropdownWidget<T>
extends class_9017 {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final int ENTRY_HEIGHT = 15;
    private static final int HEADER_HEIGHT = 19;
    private static final int BACKGROUND_COLOR = Colors.BLACK.withAlpha(0.5f).asInt();
    private final int maxHeight;
    protected final List<T> entries;
    protected final Consumer<T> selectCallback;
    protected T selected;
    private final DropdownList dropdownList;
    protected T prevSelected;
    protected boolean open;

    public DropdownWidget(int x, int y, int width, int maxHeight, @NotNull List<T> entries, @NotNull Consumer<T> selectCallback, T selected) {
        super(x, y, width, 19, (class_2561)class_2561.method_43473());
        this.maxHeight = maxHeight;
        this.entries = entries;
        this.selectCallback = selectCallback;
        this.selected = selected;
        this.dropdownList = new DropdownList(this, CLIENT, x + 1, y + 19, width - 2, maxHeight - 19);
        for (T element : entries) {
            this.dropdownList.addEntry(new Entry(element));
        }
    }

    public List<? extends class_364> method_25396() {
        return List.of(this.dropdownList);
    }

    protected void method_48579(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        this.dropdownList.field_22764 = this.open;
        this.dropdownList.method_25394(context, mouseX, mouseY, delta);
        context.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_46427() + 19 + 1, BACKGROUND_COLOR);
        context.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), 20, -1);
        DropdownWidget.method_52718((class_332)context, (class_327)DropdownWidget.CLIENT.field_1772, (class_2561)class_2561.method_43470((String)this.selected.toString()), (int)(this.method_46426() + 2), (int)(this.method_46427() + 2), (int)(this.method_55442() - 2), (int)(this.method_46427() + 19 - 2), (int)-1);
    }

    protected void method_47399(class_6382 builder) {
    }

    private void setOpen(boolean open) {
        this.open = open;
        if (this.open) {
            this.method_53533(this.maxHeight);
            this.dropdownList.method_53533(Math.min(this.entries.size() * 15 + 4, this.maxHeight - 19));
        } else {
            this.method_53533(19);
        }
    }

    protected void select(T entry) {
        this.selected = entry;
        this.setOpen(false);
        if (this.selected != this.prevSelected) {
            this.selectCallback.accept(entry);
            this.prevSelected = this.selected;
        }
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.dropdownList.method_46421(this.method_46426() + 1);
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.dropdownList.method_46419(this.method_46427() + 19);
    }

    public void method_25358(int width) {
        super.method_25358(width);
        this.dropdownList.method_25358(this.method_25368() - 2);
    }

    public void method_53533(int height) {
        super.method_53533(height);
        this.dropdownList.method_53533(height - 19);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22764) {
            return false;
        }
        if ((double)this.method_46426() <= mouseX && mouseX < (double)(this.method_46426() + this.method_25368()) && (double)this.method_46427() <= mouseY && mouseY < (double)(this.method_46427() + 19)) {
            this.setOpen(!this.open);
            this.method_25354(CLIENT.method_1483());
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected int method_44395() {
        return this.method_25364();
    }

    protected double method_44393() {
        return 0.0;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.field_22764) {
            return false;
        }
        if (this.method_19355(mouseX, mouseY).filter(e -> e.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)).isPresent()) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private class DropdownList
    extends class_4265<Entry> {
        protected DropdownList(DropdownWidget dropdownWidget, class_310 minecraftClient, int x, int y, int width, int height) {
            super(minecraftClient, width, height, y, 15);
            this.method_46421(x);
        }

        protected int addEntry(Entry entry) {
            return super.method_25321((class_350.class_351)entry);
        }

        public int method_25342() {
            return this.method_46426() + 2;
        }

        public int method_25322() {
            return this.method_25368() - 5;
        }

        protected void method_44396(class_332 context) {
            if (this.method_44392()) {
                int x1 = this.method_65507();
                int heightY = this.method_44394();
                int y1 = this.method_65508();
                context.method_25294(x1, y1 + 1, x1 + 2, y1 + heightY, -1);
            }
        }

        protected int method_65507() {
            return this.method_25342() + this.method_25322();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!this.field_22764) {
                return false;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            if (!this.field_22764) {
                return false;
            }
            return super.method_25406(mouseX, mouseY, button);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (!this.field_22764) {
                return false;
            }
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (!this.field_22764) {
                return false;
            }
            return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }

        protected void method_57713(class_332 context) {
        }

        protected void method_57715(@NotNull class_332 context) {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), BACKGROUND_COLOR);
            context.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), -1);
        }

        protected void method_49603(@NotNull class_332 context) {
            context.method_44379(this.method_46426(), this.method_46427() + 1, this.method_55442(), this.method_55443() - 1);
        }
    }

    private class Entry
    extends class_4265.class_4266<Entry> {
        private final T entry;

        protected Entry(T element) {
            this.entry = element;
        }

        @Contract(pure=true)
        @NotNull
        public @Unmodifiable List<? extends class_6379> method_37025() {
            return List.of();
        }

        @Contract(pure=true)
        @NotNull
        public @Unmodifiable List<? extends class_364> method_25396() {
            return List.of();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            DropdownWidget.method_52718((class_332)context, (class_327)DropdownWidget.CLIENT.field_1772, (class_2561)((class_2561)class_2561.method_43470((String)this.entry.toString()).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(hovered)))), (int)(x + 10), (int)y, (int)(x + entryWidth), (int)(y + 11), (int)-1);
            if (DropdownWidget.this.selected == this.entry) {
                context.method_25303(DropdownWidget.CLIENT.field_1772, "->", x + 1, y + 2, -1);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            DropdownWidget.this.select(this.entry);
            return true;
        }
    }
}

