/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.render.gui.state;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import fr.siroz.cariboustonks.util.math.MathUtils;
import fr.siroz.cariboustonks.util.render.gui.Quad;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QuadGuiElementRenderState
extends Record
implements class_11244 {
    @NotNull
    private final RenderPipeline pipeline;
    @NotNull
    private final class_11231 textureSetup;
    @NotNull
    private final List<Quad> quads;
    private final int color;
    @Nullable
    private final class_8030 scissorArea;
    @Nullable
    private final class_8030 bounds;

    public QuadGuiElementRenderState(@NotNull RenderPipeline pipeline, @NotNull class_11231 textureSetup, @NotNull List<Quad> quads, int color, @Nullable class_8030 scissorArea) {
        this(pipeline, textureSetup, quads, color, scissorArea, QuadGuiElementRenderState.createBounds(quads));
    }

    public QuadGuiElementRenderState(@NotNull RenderPipeline pipeline, @NotNull class_11231 textureSetup, @NotNull List<Quad> quads, int color, @Nullable class_8030 scissorArea, @Nullable class_8030 bounds) {
        this.pipeline = pipeline;
        this.textureSetup = textureSetup;
        this.quads = quads;
        this.color = color;
        this.scissorArea = scissorArea;
        this.bounds = bounds;
    }

    public void method_70917(class_4588 vertices, float depth) {
        for (Quad quad : this.quads) {
            vertices.method_22912(quad.x1(), quad.y1(), depth).method_39415(this.color);
            vertices.method_22912(quad.x2(), quad.y2(), depth).method_39415(this.color);
            vertices.method_22912(quad.x3(), quad.y3(), depth).method_39415(this.color);
            vertices.method_22912(quad.x4(), quad.y4(), depth).method_39415(this.color);
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    private static class_8030 createBounds(@NotNull List<Quad> quads) {
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        for (Quad quad : quads) {
            minX = Math.min(minX, quad.x1());
            minX = Math.min(minX, quad.x2());
            minX = Math.min(minX, quad.x3());
            minX = Math.min(minX, quad.x4());
            minY = Math.min(minY, quad.y1());
            minY = Math.min(minY, quad.y2());
            minY = Math.min(minY, quad.y3());
            minY = Math.min(minY, quad.y4());
            maxX = Math.max(maxX, quad.x1());
            maxX = Math.max(maxX, quad.x2());
            maxX = Math.max(maxX, quad.x3());
            maxX = Math.max(maxX, quad.x4());
            maxY = Math.max(maxY, quad.y1());
            maxY = Math.max(maxY, quad.y2());
            maxY = Math.max(maxY, quad.y3());
            maxY = Math.max(maxY, quad.y4());
        }
        return new class_8030(MathUtils.floor(minX), MathUtils.floor(minY), MathUtils.ceil(maxX - minX), MathUtils.ceil(maxY - minY));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{QuadGuiElementRenderState.class, "pipeline;textureSetup;quads;color;scissorArea;bounds", "pipeline", "textureSetup", "quads", "color", "scissorArea", "bounds"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{QuadGuiElementRenderState.class, "pipeline;textureSetup;quads;color;scissorArea;bounds", "pipeline", "textureSetup", "quads", "color", "scissorArea", "bounds"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{QuadGuiElementRenderState.class, "pipeline;textureSetup;quads;color;scissorArea;bounds", "pipeline", "textureSetup", "quads", "color", "scissorArea", "bounds"}, this, o);
    }

    @NotNull
    public RenderPipeline comp_4055() {
        return this.pipeline;
    }

    @NotNull
    public class_11231 comp_4056() {
        return this.textureSetup;
    }

    @NotNull
    public List<Quad> quads() {
        return this.quads;
    }

    public int color() {
        return this.color;
    }

    @Nullable
    public class_8030 comp_4069() {
        return this.scissorArea;
    }

    @Nullable
    public class_8030 comp_4274() {
        return this.bounds;
    }
}

