/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.shape;

import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Cuboid {
    private final int xMin;
    private final int xMax;
    private final int yMin;
    private final int yMax;
    private final int zMin;
    private final int zMax;
    private final double xMinCentered;
    private final double xMaxCentered;
    private final double yMinCentered;
    private final double yMaxCentered;
    private final double zMinCentered;
    private final double zMaxCentered;

    public Cuboid(@NotNull class_2338 a, @NotNull class_2338 b) {
        this.xMin = Math.min(a.method_10263(), b.method_10263());
        this.xMax = Math.max(a.method_10263(), b.method_10263());
        this.yMin = Math.min(a.method_10264(), b.method_10264());
        this.yMax = Math.max(a.method_10264(), b.method_10264());
        this.zMin = Math.min(a.method_10260(), b.method_10260());
        this.zMax = Math.max(a.method_10260(), b.method_10260());
        this.xMinCentered = (double)this.xMin + 0.5;
        this.xMaxCentered = (double)this.xMax + 0.5;
        this.yMinCentered = (double)this.yMin + 0.5;
        this.yMaxCentered = (double)this.yMax + 0.5;
        this.zMinCentered = (double)this.zMin + 0.5;
        this.zMaxCentered = (double)this.zMax + 0.5;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public class_2338 getCenter() {
        return new class_2338((this.xMax - this.xMin) / 2 + this.xMin, (this.yMax - this.yMin) / 2 + this.yMin, (this.zMax - this.zMin) / 2 + this.zMin);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public class_2338 getMin() {
        return new class_2338(this.xMin, this.yMin, this.zMin);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public class_2338 getMax() {
        return new class_2338(this.xMax, this.yMax, this.zMax);
    }

    public int getHeight() {
        return this.yMax - this.yMin + 1;
    }

    public int getXWidth() {
        return this.xMax - this.xMin + 1;
    }

    public int getZWidth() {
        return this.zMax - this.zMin + 1;
    }

    public double getDistanceSquared() {
        return this.getMin().method_10262((class_2382)this.getMax());
    }

    public int getTotalBlockSize() {
        return this.getHeight() * this.getXWidth() * this.getZWidth();
    }

    public boolean isInRegion(@NotNull class_2338 pos) {
        return pos.method_10263() >= this.xMin && pos.method_10263() <= this.xMax && pos.method_10264() >= this.yMin && pos.method_10264() <= this.yMax && pos.method_10260() >= this.zMin && pos.method_10260() <= this.zMax;
    }

    public boolean isInRegionWithMarge(@NotNull class_2338 pos, double marge) {
        return (double)pos.method_10263() >= this.xMinCentered - marge && (double)pos.method_10263() <= this.xMaxCentered + marge && (double)pos.method_10264() >= this.yMinCentered - marge && (double)pos.method_10264() <= this.yMaxCentered + marge && (double)pos.method_10260() >= this.zMinCentered - marge && (double)pos.method_10260() <= this.zMaxCentered + marge;
    }
}

