in Data {
    vec2 lmcoord;
    vec2 texcoord;
    vec4 glcolor;
    flat uint Material;
    flat mat3 TBN;
    vec3 ViewPos;
    #if (defined PBR_POM) && (defined GBUFFERS_TERRAIN)
        flat vec2 AtlasScale;
        flat vec2 AtlasOffset;
        vec2 LocalPos;
        vec3 TangentPos;
    #endif
} DataIn;

/* DRAWBUFFERS:12 */
layout(location = 0) out vec4 buf1;
layout(location = 1) out vec4 buf2;

#if (defined PBR_POM) && (defined GBUFFERS_TERRAIN)
    vec2 to_local_pos(vec2 texcoord) {
        return (DataIn.texcoord - DataIn.AtlasOffset) / DataIn.AtlasScale; 
    }

    vec2 from_local_pos(vec2 LocalPos) {
        return fract(LocalPos) * DataIn.AtlasScale + DataIn.AtlasOffset;
    }

    vec2 pom() {
        // Distance fade
        float Dist = len2(DataIn.ViewPos);
        if(Dist > pow2(12)) return DataIn.texcoord;

        float Height = texture(normals, DataIn.texcoord).a;
        if(Height > 254.0 / 255) {
            return DataIn.texcoord;
        }

        vec3 TangentPos = normalize(DataIn.TangentPos);
        vec3 Offset = vec3(TangentPos.xy / -TangentPos.z * POM_MAX_DEPTH, 1) / POM_STEP_COUNT;
        float Dither = dither(gl_FragCoord.xy, true);
        vec3 CurrentPos = vec3(DataIn.LocalPos, 0) + Offset * Dither; 
        
        for(int i = 0; i < POM_STEP_COUNT && Height - CurrentPos.z > 0.5 / 255; i++) {
            Height = 1 - texture(normals, from_local_pos(CurrentPos.xy)).a;
            CurrentPos += Offset;
        }
        
        // Need to move back one here
        vec2 Final = from_local_pos(CurrentPos.xy - Offset.xy);

        return Final;
    }
#endif

void init_frag() {
    #if (defined PBR_POM) && (defined GBUFFERS_TERRAIN)
        vec2 texcoord = pom();
    #else
        vec2 texcoord = DataIn.texcoord;
    #endif
    vec4 Albedo = DataIn.glcolor * texture(texture, texcoord);
    if (Albedo.a < 0.1) {
        discard;
        return;
    }

    vec3 ScreenPos = gl_FragCoord.xyz * vec3(resolutionInv, 1);
    #ifdef DH_TERRAIN
        bool IsDH = true;
    #else
        bool IsDH = false;
    #endif
    Positions Pos = get_positions(ScreenPos.xy, ScreenPos.z, IsDH, false);
    #ifdef DISTANT_HORIZONS
        float Dither = bayer8(gl_FragCoord.xy);
        if (transition_to_dh(Pos.Player, Dither)) {
            discard;
            return;
        }
        #if (defined DH_NOISE) && (defined DH_TERRAIN)
            Albedo.rgb = dh_noise(Pos.Player, Albedo.rgb);
        #endif
    #endif

    Albedo.rgb = pow(Albedo.rgb, vec3(2.2));
    Albedo.rgb *= DataIn.glcolor.a;
    Albedo.rgb *= texture(normals, texcoord).b;
    Albedo.rgb = pow(Albedo.rgb, vec3(1 / 2.2));

    #ifdef GBUFFERS_ENTITIES
    Albedo.rgb = mix(Albedo.rgb, entityColor.rgb, entityColor.a);
    #endif

    buf1.x = packUnorm2x8(Albedo.rg);
    buf1.y = packUnorm2x8(vec2(Albedo.b, float(DataIn.Material) / 255));

    buf1.z = packUnorm2x8(texture(specular, texcoord).rg);

    vec3 PackNormal = get_normal(texcoord);
    vec3 Normal = DataIn.TBN * PackNormal;

    buf1.w = packUnorm2x8(encodeUnitVector(view_player(Normal)) * 0.5 + 0.5);

    vec2 Lightmap = DataIn.lmcoord + bayer8(gl_FragCoord.xy) / 255.0;

    buf2.x = packUnorm2x8(Lightmap);

    float PackSSS = get_sss(texcoord);
    float Emissiveness = get_emissiveness(texcoord);
    
    buf2.z = packUnorm2x8(vec2(PackSSS, Emissiveness));

    buf2.w = packUnorm2x8(encodeUnitVector(view_player(DataIn.TBN[2])) * 0.5 + 0.5);

}
