uniform float viewWidth;
uniform float viewHeight;
uniform float aspectRatio;
uniform int isEyeInWater;
uniform float frameTime;
uniform float frameTimeCounter;
uniform vec3 fogColor;
uniform vec3 cameraPosition;
uniform vec4 entityColor;
uniform int worldTime;
uniform float rainStrength;
uniform float thunderStrength;
uniform float temperature;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform int worldDay;
uniform int heldBlockLightValue;
uniform int heldBlockLightValue2;
uniform float darknessFactor;
uniform float darknessLightFactor;
uniform float blindness;
uniform ivec2 eyeBrightnessSmooth;
uniform vec3 upPosition;
uniform vec3 previousCameraPosition;
uniform int frameCounter;
uniform vec3 shadowLightPosition;
uniform float sunAngle;
uniform int renderStage;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
uniform sampler2D colortex6;
uniform sampler2D colortex7;
uniform sampler2D colortex8;
uniform sampler2D colortex9;
uniform sampler2D shadowtex0;
uniform sampler2D shadowtex1;
uniform sampler2D shadowcolor0;
uniform sampler2D shadowcolor1;
uniform sampler2D texture;
uniform sampler2D lightmap;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;
uniform sampler2D specular;
uniform sampler2D normals;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferProjection;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 shadowModelView;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowProjectionInverse;

uniform float near;
uniform float far;

// Custom Uniforms
uniform float timeAngle;
uniform float nightStrength;
uniform float dayStrength;
uniform float sunsetStrength;
uniform float sunriseStrength;
uniform vec2 resolution;
uniform vec2 resolutionInv;
uniform vec2 taaJitter;
uniform vec3 sunPosN;
uniform vec3 sLightPosN;
uniform float isIndoorsSmooth;
uniform float precipitationSmooth;

// Weather related custom uniforms
uniform float cloudStartOffset;
uniform float cloudCoverageVl;
uniform float cloudCoverageFlat;
uniform float anisotropy;
uniform float fogAmount;

uniform sampler2D waterNoise;
uniform sampler2D cloudNoise;
uniform sampler2D blueNoiseTexture;
uniform sampler2D image0Sampler;
uniform sampler2D image1Sampler;
uniform sampler2D atm_transmittance_sampler;
uniform sampler2D atm_skyview_sampler;
uniform sampler2D atm_multi_scattering_sampler;
uniform sampler3D worleyNoiseTexture;
uniform sampler2D smaaAreaTexture;
uniform sampler2D smaaSearchTexture;

layout(rgba16f) uniform restrict image2D image0;
layout(rg8) uniform restrict image2D image1;
layout(rgba16f) uniform restrict image2D atm_transmittance;
layout(rgba16f) uniform restrict image2D atm_skyview;
layout(rgba16f) uniform restrict image3D atm_aerial_perspective;
layout(rgba16f) uniform restrict image2D atm_multi_scattering;

uniform float dhFarPlane;
uniform float dhNearPlane;

uniform sampler2D dhDepthTex0;
uniform sampler2D dhDepthTex1;

uniform mat4 dhProjectionInverse;
uniform mat4 dhProjection;
uniform mat4 dhPreviousProjection;

uniform int dhRenderDistance;

const float sunPathRotation = -35.0;
const bool colortex0Clear = false;
const bool colortex1Clear = false;
const bool colortex2Clear = false;
const bool colortex3Clear = false;
const bool colortex4Clear = false;
const bool colortex5Clear = false;
const bool colortex6Clear = false;
const bool colortex7Clear = false;
const bool colortex8Clear = false;
const bool colortex9Clear = false;
const bool shadowcolor0Clear = true;
const vec4 shadowcolor0ClearColor = vec4(0, 0, 0, 1);
const bool shadowcolor1Clear = true;

const float PI = 3.141592653589793;
const float TAU = 2 * PI;

const bool shadowHardwareFiltering = true;
uniform sampler2DShadow shadowtex0HW;
uniform sampler2DShadow shadowtex1HW;

const int noiseTextureResolution = 512;

layout(std430, binding = 0) restrict buffer dataBuffer {
    vec3 SunColor;
    float DofFocus;
    vec3 MoonColor;
    float AvgLum;
    vec3 AmbientColor;
    float SunVisibility;
} dataBuf;

layout(std430, binding = 1) restrict buffer dispatchBuffer {
    uvec3 mip1, mip2, mip3, mip4, mip5;
} dispatchBuf;

layout(std430, binding = 2) restrict buffer histogramBuffer {
    uint data[256];
} histogramBuf;

const float SEA_LEVEL = 62.9;

const float CLOUD_TEX_SIZE = 128.0;

const float shadowDistanceRenderMul = 1.0;

/*
const int colortex0Format = RGB16F;
const int colortex1Format = RGBA16;
const int colortex2Format = RGBA16;
const int colortex3Format = RGBA16F;
const int colortex4Format = RGB16F;
const int colortex5Format = RG8;
const int colortex6Format = RGBA16F;
const int colortex7Format = RGBA16F;
const int colortex8Format = R16;
const int colortex9Format = RGBA16F;
const int shadowcolor1Format = RG8;
*/
