#include "/lib/all_the_libs.glsl"

in vec2 texcoord;

#include "/generic/post/bloom.glsl"

/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 Color;

void main() {
    Color = texture(colortex0, texcoord);

    #ifdef BLOOM
    float Offset = 0;
    vec3 FinalBloom = blur3x3(image0Sampler, 1 - texcoord * vec2(256 * aspectRatio, 256) * resolutionInv).rgb;

    float WeatherColor = texture(colortex5, texcoord).g * 0.5;

    Color.rgb += FinalBloom * (BLOOM_STRENGTH + float(isEyeInWater == 1) * 0.5 + 0.2 * (rainStrength * isIndoorsSmooth) + WeatherColor);
    #endif
}
