#include "/lib/all_the_libs.glsl"
// Clouds

#include "/generic/sky.glsl"
#include "/generic/clouds.glsl"

#ifdef CLOUDS
const vec2 workGroupsRender = vec2(CLOUD_RES_SCALING, CLOUD_RES_SCALING);
#else
const vec2 workGroupsRender = vec2(0, 0);
#endif

layout(local_size_x = 16, local_size_y = 16) in;
void main() {
    const int CLOUD_RES_SCALING_INV = int(1 / CLOUD_RES_SCALING);
    vec2 FragPos = gl_GlobalInvocationID.xy * CLOUD_RES_SCALING_INV + ivec2(frameCounter * CLOUD_RES_SCALING, frameCounter) % CLOUD_RES_SCALING_INV;
    vec2 texcoord = FragPos * resolutionInv;
    bool IsDH;
    float Depth = max_depth_4x4(texcoord, IsDH);

    vec4 CloudData = vec4(0, 0, 0, 0);

    Positions Pos = get_positions(texcoord, Depth, IsDH, true);

    float _DepthCloud = 1e6;
    CloudData = get_clouds(Pos.Player, Pos.PlayerN, 32, cameraPosition, true, FragPos, Depth, _DepthCloud);

    if(_DepthCloud < 1e6) {
        _DepthCloud = max(farLod, _DepthCloud);
    }

    _DepthCloud /= far;

    // Transmittance should default to 1
    CloudData.a = 1 - CloudData.a;
    imageStore(image0, ivec2(gl_GlobalInvocationID.xy), CloudData);
    imageStore(image1, ivec2(gl_GlobalInvocationID.xy), vec4(_DepthCloud, 0, 0, 0));
}
