#define DEFERRED

in vec2 texcoord;

flat in vec3 LightColorDirect;

/* DRAWBUFFERS:056 */
layout(location = 0) out vec4 Color;
layout(location = 1) out vec4 Shadow;
layout(location = 2) out vec4 Temporal;

#include "/lib/all_the_libs.glsl"
#include "/generic/water.glsl"
#include "/generic/fog.glsl"
#include "/generic/shadow/main.glsl"
#include "/generic/lighting.fsh"
#include "/generic/sky.glsl"
#include "/generic/clouds.glsl"
#include "/generic/post/taa.glsl"

void main() {
    bool IsDH;
    float Depth = get_depth(texcoord, IsDH);
    bool IsHand = Depth <= 0.56;
    if (IsHand) {
        Depth = Depth * 2 - 1;
        Depth /= MC_HAND_DEPTH;
        Depth = Depth * 0.5 + 0.5;
    }
    Positions Pos = get_positions(texcoord, Depth, IsDH, true);

    float Dither = dither(gl_FragCoord.xy, true);

    if (Depth == 1) {
        Color.rgb = get_sky(Pos.ViewN, true, Pos.PlayerN.y);
        #ifdef DIMENSION_OVERWORLD
            if(dot(Pos.View, gbufferModelView[1].xyz) > 0) {
                Color.rgb += get_stars(Pos.PlayerN);
                Color.rgb += get_aurora(Pos.PlayerN, Dither);
            }
        #endif
    }
    else {
        vec4 Data = texture(colortex1, texcoord);
        vec4 Data2 = texture(colortex2, texcoord);

        vec2 UnpackX = unpackUnorm2x8(Data.x);
        vec2 UnpackY = unpackUnorm2x8(Data.y);

        vec3 Albedo = vec3(UnpackX, UnpackY.x);
        Albedo.rgb = srgb_linear(Albedo.rgb);
        float Material = UnpackY.y * 255;
        vec2 Lightmap = unpackUnorm2x8(Data2.x);
        vec3 Normal = decodeUnitVector(unpackUnorm2x8(Data.w) * 2 - 1);
        Normal = player_view(Normal);
        vec3 FlatNormal = decodeUnitVector(unpackUnorm2x8(Data2.w) * 2 - 1);
        FlatNormal = player_view(FlatNormal);
        vec2 Unpack2Z = unpackUnorm2x8(Data2.z);
        float PackSSS = Unpack2Z.x, Emissiveness = Unpack2Z.y;
        Color.rgb = calc_lighting(Pos, IsDH, texcoord, Albedo, Material, PackSSS, Emissiveness, Lightmap, Normal, FlatNormal, IsHand, Shadow);
    }

    #ifdef CLOUDS
        Temporal = temporal_upscale_clouds(Pos.Screen, IsDH, ivec2(gl_FragCoord.xy), Pos.Player, colortex6);
        Color.rgb = Color.rgb * Temporal.a + Temporal.rgb;
    #endif
}
