#include "/lib/all_the_libs.glsl"

void main() {
    if (gl_VertexID == 0) {
        dataBuf.SunColor = get_direct_color(false);
        dataBuf.MoonColor = get_direct_color(true);
    }
    else if (gl_VertexID == 1) {
        #ifdef DIMENSION_OVERWORLD
        dataBuf.AmbientColor = get_ambient_color();
        #endif

        #ifdef BLOOM
        float ar = aspectRatio;
        dispatchBuf.mip1 = uvec3(ceil(64 * ar), 16, 1);
        dispatchBuf.mip2 = uvec3(ceil(32 * ar), 8, 1);
        dispatchBuf.mip3 = uvec3(ceil(16 * ar), 4, 1);
        dispatchBuf.mip4 = uvec3(ceil(8 * ar), 2, 1);
        dispatchBuf.mip5 = uvec3(ceil(4 * ar), 1, 1);
        #endif
    }
    gl_Position = vec4(-1);
}
