in Data {
    vec2 lmcoord;
    vec2 texcoord;
    vec4 glcolor;
    flat uint Material;
    flat mat3 TBN;
    vec3 ViewPos;
} DataIn;

void init_frag() {
    vec4 Albedo = vec4(DataIn.glcolor.rgb, 1);
    #ifndef NO_TEXTURE
    Albedo *= texture(texture, DataIn.texcoord);
    #endif
    if (Albedo.a < 0.1) {
        discard;
        return;
    }
    Albedo.rgb = pow(Albedo.rgb, vec3(2.2));
    Albedo.rgb *= DataIn.glcolor.a;
    Albedo.rgb = pow(Albedo.rgb, vec3(1 / 2.2));

    #ifdef GBUFFERS_ENTITIES
    Albedo.rgb = mix(Albedo.rgb, entityColor.rgb, entityColor.a);
    #endif

    vec3 PackNormal = get_normal(DataIn.texcoord);
    vec3 Normal = DataIn.TBN * PackNormal;

    /* DRAWBUFFERS:12 */
    vec4 OutData;
    OutData.x = packUnorm2x8(Albedo.rg);
    OutData.y = packUnorm2x8(vec2(Albedo.b, float(DataIn.Material) / 255));
    OutData.z = packUnorm2x8(texture(specular, DataIn.texcoord).rg);
    OutData.w = packUnorm2x8(encodeUnitVector(view_player(Normal)) * 0.5 + 0.5);
    gl_FragData[0] = OutData;
    OutData.x = packUnorm2x8(DataIn.lmcoord + bayer8(gl_FragCoord.xy) / 255.0);
    OutData.z = packUnorm2x8(texture(specular, DataIn.texcoord).zw);
    OutData.w = packUnorm2x8(encodeUnitVector(view_player(DataIn.TBN[2])) * 0.5 + 0.5);
    gl_FragData[1] = OutData;
}
