void init_frag_translucent() {
    vec3 ScreenPos = gl_FragCoord.xyz * vec3(resolutionInv, 1);
    vec3 PlayerPos = view_player(DataIn.ViewPos);
    vec3 WorldPos = PlayerPos + cameraPosition;
    /* DRAWBUFFERS:012 */
    vec4 Albedo = texture(texture, DataIn.texcoord);
    Albedo *= DataIn.glcolor;
    if (Albedo.a < 0.1) {
        discard;
        return;
    }
    Albedo.rgb = pow(Albedo.rgb, vec3(2.2));

    vec3 PackNormal = get_normal(DataIn.texcoord);
    vec3 Normal = DataIn.TBN * PackNormal;
    if (DataIn.Material == MATERIAL_WATER) {
        vec3 WorldNormal = view_player(Normal);
        Normal = DataIn.TBN * get_water_normal(WorldPos, WorldNormal, DataIn.ViewPos.z);
    }

    if (DataIn.Material == MATERIAL_WATER) {
        Albedo = vec4(0);
    }

    float PackSSS = texture(specular, DataIn.texcoord).z;
    float Emissiveness = texture(specular, DataIn.texcoord).w;

    vec4 OutData;
    OutData.x = packUnorm2x8(Albedo.rg);
    OutData.y = packUnorm2x8(vec2(Albedo.b, float(DataIn.Material) / 255));
    OutData.z = packUnorm2x8(texture(specular, DataIn.texcoord).rg); // flat normal
    OutData.w = packUnorm2x8(encodeUnitVector(view_player(Normal)) * 0.5 + 0.5);
    gl_FragData[1] = OutData;
    OutData.x = packUnorm2x8(DataIn.lmcoord + bayer8(gl_FragCoord.xy) / 255.0);

    OutData.w = packUnorm2x8(encodeUnitVector(view_player(DataIn.TBN[2])) * 0.5 + 0.5);
    gl_FragData[2] = OutData;

    if (DataIn.Material != MATERIAL_WATER) {
        Albedo.rgb = calc_lighting(DataIn.texcoord, Albedo.rgb, DataIn.Material, PackSSS, Emissiveness, DataIn.lmcoord,
                Normal, DataIn.TBN[2], DataIn.ViewPos, ScreenPos, PlayerPos, false);
    }

    gl_FragData[0] = Albedo;
}
