#include "/generic/gtao.glsl"

vec3 calc_lighting(vec2 texcoord, vec3 Color, float Material, float PackSSS, float Emissiveness, vec2 Lightmap,
    vec3 Normal, vec3 FlatNormal, vec3 ViewPos, vec3 ScreenPos, vec3 PlayerPos, bool IsHand) {
    if (Material >= MATERIAL_TALL_PLANT_LOWER && Material <= MATERIAL_SHORT_PLANT) {
        Normal = gbufferModelView[1].xyz; // upDirection
    }
    float NdotL = dot(sLightPosN, Normal);

    if (IsHand) {
        // Prevents a strange rare lightleak
        NdotL *= Lightmap.y;
    }

    Lightmap = pow4(Lightmap);

    vec3 SunA = dataBuf.AmbientColor; // Value written in prepare, in the data buffer

    SunA = mix(MinLight, SunA, Lightmap.y);

    Color += Color * Emissiveness * 2 * float(Emissiveness < 1);

    vec3 OutColor = Color * (SunA + Lightmap.x * TorchlightColor);

    float SSSS = PackSSS;
    if (PackSSS < 64.0 / 255.0) {
        if (Material == MATERIAL_SSS_WEAK) SSSS = SSS_STRENGTH_STRONG;
        else if (Material >= MATERIAL_SSS_STRONG && Material <= MATERIAL_LEAVES) SSSS = SSS_STRENGTH_WEAK;
        else SSSS = 0;
    }
    bool DoSSS = SSSS > 0;

    vec3 SunDirect;
    bool IsMetal, IsHardcodedMetal;
    vec3 Shadow;
    mat2x3 F0 = get_f0(texcoord, Material, Color, IsMetal, IsHardcodedMetal);
    if (NdotL > 0 || DoSSS) {
        Shadow = get_shadow(PlayerPos, FlatNormal, Material, Lightmap.y, DoSSS);

        if (Shadow != vec3(0)) {
            vec3 LightColor;
            if (sunAngle < 0.5)
                LightColor = dataBuf.SunColor;
            else
                LightColor = dataBuf.MoonColor;

            float LHeight = sin(sunAngle * TAU); // to_player_pos(sunPosN).y;
            LightColor *= smoothstep(0, 0.05, abs(LHeight));

            vec3 V = normalize(-ViewPos);

            SunDirect = float(!IsMetal) * Color / PI;

            SunDirect *= LightColor * max(NdotL, 0);
            if (DoSSS) {
                SSSS = (1 - SSSS) * 2;

                float SSS = exp(-SSSS * abs(NdotL) / 5);
                SunDirect += Color.rgb * LightColor * SSS * ISOTROPIC_PHASE;
            }

            // if (isEyeInWater == 1) {
            //     float DistToSun = (1 - Lightmap.y) * 15 / view_player(sLightPosN).y;
            //     vec3 Transmittance = exp(-WaterAbsorbtion * DistToSun * 0.5);
            //     SunDirect *= Transmittance;
            // }
        }
    }
    OutColor = OutColor * max(0.1, float(!IsMetal)) + SunDirect * Shadow;

    return OutColor;
}
