vec3 get_sky(vec3 ViewPosN, const bool DrawSun, float PlayerPosY) {
    vec3 UVW = to_uvw(cameraPosition.y * 5 + EarthRad, get_phi(ViewPosN), get_delta(sunPosN));
    UVW.y = SmoothMax(UVW.y, 0.5, 0.01);

    UVW.z = clamp(UVW.z, TEXEL_SIZE_INV, 1 - TEXEL_SIZE_INV);
    float VdotSun = dot(sunPosN, ViewPosN);

    UVW.z *= 0.5;
    vec3 Scattering = sample_scattering(UVW, false);
    vec3 RlhS = Scattering * rayleigh_phase(VdotSun);
    UVW.z += 0.5;
    Scattering = sample_scattering(UVW, false);
    vec3 MieS = Scattering * cs_phase(VdotSun);

    vec3 SkyColor = RlhS + MieS;

    float VdotMoon = dot(-sunPosN, ViewPosN);
    UVW.z = to_uvw(0, 0, get_delta(-sunPosN)).z;
    UVW.z = clamp(UVW.z, TEXEL_SIZE_INV, 1 - TEXEL_SIZE_INV);
    UVW.z *= 0.5;
    Scattering = sample_scattering(UVW, true);
    RlhS = Scattering * rayleigh_phase(VdotMoon);
    UVW.z += 0.5;
    Scattering = sample_scattering(UVW, true);
    MieS = Scattering * cs_phase(VdotMoon);

    SkyColor += RlhS + MieS;

    float Fade = smoothstep(-0.02, 0.1, PlayerPosY);

    if (DrawSun) {
        SkyColor += step(0.9995, VdotSun) * dataBuf.SunColor * Fade;
        SkyColor += step(0.9997, VdotMoon) * dataBuf.MoonColor * Fade;
    }

    return SkyColor;
}
