uniform float viewWidth;
uniform float viewHeight;
uniform int isEyeInWater;
uniform float frameTime;
uniform float frameTimeCounter;
uniform vec3 fogColor;
uniform vec3 cameraPosition;
uniform vec4 entityColor;
uniform int worldTime;
uniform float rainStrength;
uniform float temperature;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform int worldDay;
uniform int heldBlockLightValue;
uniform int heldBlockLightValue2;
uniform float darknessFactor;
uniform float darknessLightFactor;
uniform float blindness;
uniform ivec2 eyeBrightnessSmooth;
uniform vec3 upPosition;
uniform vec3 previousCameraPosition;
uniform int frameCounter;
uniform vec3 shadowLightPosition;
uniform float sunAngle;
uniform int renderStage;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
uniform sampler3D colortex6;
uniform sampler2D shadowtex0;
uniform sampler2D shadowtex1;
uniform sampler2D shadowcolor0;
uniform sampler2D shadowcolor1;
uniform sampler2D texture;
uniform sampler2D lightmap;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;
uniform sampler2D specular;
uniform sampler2D normals;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferProjection;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 shadowModelView;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowProjectionInverse;

uniform float near;
uniform float far;

uniform float timeAngle;
uniform float nightStrength;
uniform float dayStrength;
uniform float sunsetStrength;
uniform float sunriseStrength;
uniform vec2 resolution;
uniform vec2 resolutionInv;
uniform float shadowTexSize;
uniform vec2 taaJitter;
uniform vec3 sunPosN;
uniform vec3 sLightPosN;
uniform float isIndoorsSmooth;
uniform sampler2D waterNoise;
uniform sampler3D scatteringTexture;
uniform sampler2D blueNoiseTexture;
uniform sampler2D bloomSampler;
uniform sampler3D worleyNoiseTexture;

layout(rgba16f) uniform image2D bloomImage;
const float sunPathRotation = -35.0;
const bool colortex0Clear = false;
const bool colortex1Clear = false;
const bool colortex2Clear = false;
const bool colortex3Clear = false;
const bool colortex4Clear = false;
const bool shadowcolor0Clear = true;
const vec4 shadowcolor0ClearColor = vec4(0, 0, 0, 1);
const bool shadowcolor1Clear = true;

const float PI = 3.141592653589793;
const float TAU = 2 * PI;

const bool shadowHardwareFiltering = true;
uniform sampler2DShadow shadowtex0HW;
uniform sampler2DShadow shadowtex1HW;

layout(std430, binding = 0) buffer dataBuffer {
    vec3 SunColor;
    vec3 MoonColor;
    float LastAvgLum;
    vec3 AmbientColor;
} dataBuf;

const float SEA_LEVEL = 62.9;

/*
const int colortex0Format = RGBA16F;
const int colortex1Format = RGBA16;
const int colortex2Format = RGBA16;
const int colortex3Format = RGBA16F;
const int colortex4Format = RGBA16F;
const int shadowcolor1Format = RG8;
*/
