#include "/lib/all_the_libs.glsl"

in vec2 texcoord;
flat in float AvgLum;
flat in vec3 LightColorDirect;

#include "/generic/post/taa.glsl"
#include "/generic/shadow/rsm.glsl"
#include "/generic/post/bloom.glsl"
const bool colortex0MipmapEnabled = true;
/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 Color;

void main() {
    Color = texture(colortex0, texcoord);

    if (all(lessThan(gl_FragCoord.xy, vec2(1)))) {
        dataBuf.LastAvgLum = AvgLum;
    }

    #ifdef BLOOM
    float Offset = 0;
    vec3 FinalBloom = blur3x3(bloomSampler, 1 - texcoord / 4).rgb;

    Color.rgb += FinalBloom * clamp(BLOOM_STRENGTH, 0, 1);
    #endif

    Color.rgb *= (1 / AvgLum) * EXPOSURE_MULT;

    Color.rgb = apply_tonemap(Color.rgb);
    Color.rgb = pow(Color.rgb, vec3(1 / 2.2));
}
