#include "/lib/all_the_libs.glsl"

flat out float AvgLum;
flat out vec3 LightColorDirect;

float get_avg_lum() {
	float mip = log2(min(viewWidth, viewHeight))-1;
	vec3 AvgCol = textureLod(colortex0, vec2(0.5, 0.5), mip).rgb;
	AvgCol += textureLod(colortex0, vec2(0.25, 0.75), mip).rgb;
	AvgCol += textureLod(colortex0, vec2(0.75, 0.25), mip).rgb;
	AvgCol += textureLod(colortex0, vec2(0.25, 0.25), mip).rgb;
	AvgCol += textureLod(colortex0, vec2(0.75, 0.75), mip).rgb;
	
	float AvgLum = get_luminance(AvgCol);
	return AvgLum;
}

float auto_exposure() {
	float LastLum = dataBuf.LastAvgLum;
	float AvgLum = get_avg_lum();

	const float AdjSpeed = frameTime * EXPOSURE_SPEED;
	AvgLum = mix(LastLum, AvgLum, AdjSpeed / (1+AdjSpeed));
	AvgLum = max(AvgLum, 0.3);

	return AvgLum;
}

out vec2 texcoord;
void main() {
	gl_Position = ftransform();
	texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
	AvgLum = auto_exposure();
	LightColorDirect = get_shadowlight_color();
}
