#include "/lib/all_the_libs.glsl"

layout(local_size_x = 1, local_size_y = 1) in;

const vec2 workGroupsRender = vec2(0.0625, 0.0625);
const vec2 SAMPLE_OFFSET = vec2(0.3125);
const vec2 OFFSET = vec2(0.25);
#include "/generic/post/bloom.glsl"

void main() {
    ivec2 GlobalPos = ivec2(gl_GlobalInvocationID.xy);

    vec2 SamplePos = GlobalPos * resolutionInv * 0.25 + SAMPLE_OFFSET;
    vec3 Color = read_blurred_bloom(SamplePos, false);
    Color += read_bloom(GlobalPos * resolutionInv + OFFSET, true);
    write_bloom(GlobalPos + ivec2(OFFSET * resolution), Color, false);
}
