#include "/lib/all_the_libs.glsl"
#include "/generic/post/taa.glsl"
in vec2 texcoord;

/* DRAWBUFFERS:04 */
layout(location = 0) out vec4 Color;
layout(location = 1) out vec4 TAAData;

vec3 apply_vignette(vec3 Color, vec2 Pos) {
    Pos = Pos - 0.5;
    float Strength = length(Pos * VIGNETTE_OPACITY);
    Strength = pow(Strength, 4 - VIGNETTE_FALLOFF);
    Color *= 1 - min(Strength, 1);
    return Color;
}

void main() {
    Color = texture(colortex0, texcoord);

    #ifndef DEBUG_DISABLE_TEMPORAL
    TAAData.rgb = TAA(Color.rgb, ivec2(gl_FragCoord.xy), texcoord);
    Color.rgb = TAAData.rgb;
    #endif

    Color.rgb += (bayer8(gl_FragCoord.xy) - 0.5) / 255;

    Color.rgb = purkinje_effect(Color.rgb);

    #ifdef FILM_GRAIN
    Color.rgb = film_grain(Color.rgb, gl_FragCoord.xy);
    #endif

    Color.rgb = apply_vibrance(Color.rgb, VIBRANCE);
    Color.rgb = apply_saturation(Color.rgb, SATURATION);
    Color.rgb = apply_contrast(Color.rgb, CONTRAST);

    Color.rgb = apply_vignette(Color.rgb, texcoord);
}
